/*! \file CreateLoadsPrognostic2.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../include/typedefs.h"
#include "../IoModel.h"

void	CreateLoadsPrognostic2(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i,j;
	int i1,i2;
	int pos1,pos2;
	double e1,e2;

	/*Output*/
	DataSet* loads=NULL;

	/*numericalflux intermediary data: */
	char numericalflux_type[NUMERICALFLUXSTRING];
	int  numericalflux_id;
	int  numericalflux_node_ids[MAX_NUMERICALFLUX_NODES];
	int  numericalflux_elem_id;
	double numericalflux_h[MAX_NUMERICALFLUX_NODES];

	/*Create loads: */
	loads   = new DataSet(LoadsEnum);

	/*Get edges and elements*/
	IoModelFetchData(&iomodel->edges,&iomodel->numberofedges,NULL,iomodel_handle,"edges");
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");

	/*First load data:*/
	for (i=0;i<iomodel->numberofedges;i++){

		/*Get left and right elements*/
		e1=iomodel->edges[4*i+2]-1; //edges are [node1 node2 elem1 elem2]
		e2=iomodel->edges[4*i+3]-1; //edges are [node1 node2 elem1 elem2]

		/*Now, if this element is not in the partition, pass: */
		if(!iomodel->my_elements[(int)e1]) continue;

		/*Create load*/
		numericalflux_id=i+1; //Matlab indexing
		numericalflux_elem_id=(int)e1+1;//id is in matlab index

		/*1: Get vertices ids*/
		i1=(int)iomodel->edges[4*i+0];
		i2=(int)iomodel->edges[4*i+1];

		if (!isnan(e2)){
			strcpy(numericalflux_type,"internal");

			/*Now, we must get the nodes of the 4 nodes located on the edge*/

			/*2: Get the column where these ids are located in the index*/
			pos1=pos2=UNDEF;
			for(j=0;j<3;j++){
				if (iomodel->elements[3*(int)e1+j]==i1) pos1=j+1;
				if (iomodel->elements[3*(int)e2+j]==i1) pos2=j+1;
			}
			ISSMASSERT(pos1!=UNDEF && pos2!=UNDEF);

			/*3: We have the id of the elements and the position of the vertices in the index
			 * we can compute their dofs!*/
			numericalflux_node_ids[0]=3*(int)e1+pos1;       //ex: 1 2 3
			numericalflux_node_ids[1]=3*(int)e1+(pos1%3)+1; //ex: 2 3 1
			numericalflux_node_ids[2]=3*(int)e2+pos2;           //ex: 1 2 3
			numericalflux_node_ids[3]=3*(int)e2+((pos2+1)%3)+1; //ex: 3 1 2

			numericalflux_h[0]=iomodel->thickness[(int)iomodel->elements[numericalflux_node_ids[0]-1] -1];
			numericalflux_h[1]=iomodel->thickness[(int)iomodel->elements[numericalflux_node_ids[1]-1]-1];
			numericalflux_h[2]=iomodel->thickness[(int)iomodel->elements[numericalflux_node_ids[2]-1]-1];
			numericalflux_h[3]=iomodel->thickness[(int)iomodel->elements[numericalflux_node_ids[3]-1]-1];
		}
		else{
			strcpy(numericalflux_type,"boundary");

			/*2: Get the column where these ids are located in the index*/
			pos1==UNDEF;
			for(j=0;j<3;j++){
				if (iomodel->elements[3*(int)e1+j]==i1) pos1=j+1;
			}
			ISSMASSERT(pos1!=UNDEF);

			/*3: We have the id of the elements and the position of the vertices in the index
			 * we can compute their dofs!*/
			numericalflux_node_ids[0]=3*(int)e1+pos1;
			numericalflux_node_ids[1]=3*(int)e1+(pos1%3)+1;

			numericalflux_h[0]=iomodel->thickness[(int)iomodel->elements[numericalflux_node_ids[0]-1]-1];
			numericalflux_h[1]=iomodel->thickness[(int)iomodel->elements[numericalflux_node_ids[1]-1]-1];
			numericalflux_h[2]=UNDEF;
			numericalflux_h[3]=UNDEF;
		}

		loads->AddObject(new Numericalflux(numericalflux_id,numericalflux_type,numericalflux_node_ids,numericalflux_elem_id,numericalflux_h));
	}

	/*Free data: */
	xfree((void**)&iomodel->edges);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->thickness);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	/*Assign output pointer: */
	*ploads=loads;

}
