#include "stdio.h"
#include "../shared/shared.h"
#include "../include/macros.h"
#include "./BamgOpts.h"

void BamgOptsInit(BamgOpts* bamgopts){

	bamgopts->iso=0;
	bamgopts->maxnbv=0;
	bamgopts->MaximalAngleOfCorner=0;
	bamgopts->Hessiantype=0;
	bamgopts->Metrictype=0;
	bamgopts->KeepVertices=0;
	bamgopts->Crack=0;
	bamgopts->maxsubdiv=0;
	bamgopts->power=0;
	bamgopts->anisomax=0;
	bamgopts->NbSmooth=0;
	bamgopts->nbjacobi=0;
	bamgopts->omega=0;
	bamgopts->hmin=0;
	bamgopts->hmax=0;
	bamgopts->hminVertices=NULL;
	bamgopts->hmaxVertices=NULL;
	bamgopts->gradation=0;
	bamgopts->cutoff=0;
	bamgopts->splitcorners=0;
	bamgopts->geometricalmetric=0;
	bamgopts->verbose=0;
	bamgopts->err=NULL;
	bamgopts->errg=0;
	bamgopts->coef=0;
	bamgopts->metric=NULL;
	bamgopts->field=NULL;
	bamgopts->numfields=0;

}

void BamgOptsCheck(BamgOpts* bamgopts){

	int i;

	if (bamgopts->coef==0) ISSMERROR("'coef' should be positive");
	if (bamgopts->maxsubdiv<=1) ISSMERROR("'maxsubdiv' should be >1");
	if (bamgopts->Crack!=0  && bamgopts->Crack!=1) ISSMERROR("'Crack' supported options are 0 and 1");
	if (bamgopts->Hessiantype!=0  && bamgopts->Hessiantype!=1) ISSMERROR("'Hessiantype' supported options are 0 and 1");
	if (bamgopts->Metrictype!=0   && bamgopts->Metrictype!=1 && bamgopts->Metrictype!=2) ISSMERROR("'Metrictype' supported options are 0, 1 and 2");
	if (bamgopts->KeepVertices!=0 && bamgopts->KeepVertices!=1) ISSMERROR("'KeepVertices' supported options are 0 and 1");
	if (bamgopts->errg<0) ISSMERROR("'errg' option should be >0");
	if (bamgopts->nbjacobi<=0) ISSMERROR("'nbjacobi' option should be >0");
	if (bamgopts->geometricalmetric!=0  && bamgopts->geometricalmetric!=1) ISSMERROR("'geometricalmetric' supported options are 0 and 1");
	if (bamgopts->NbSmooth<=0) ISSMERROR("'NbSmooth' option should be >0");
	if (bamgopts->maxnbv<3) ISSMERROR("'maxnbv' option should be >3");
	if (bamgopts->hmin<=0) ISSMERROR("'hmin' option should be >0");
	if (bamgopts->hmax<=0 || bamgopts->hmax<bamgopts->hmin) ISSMERROR("'hmax' option should be between 0 and hmin=%g",bamgopts->hmin);
	if (bamgopts->anisomax<1) ISSMERROR("'anisomax' option should be >=1");
	if (bamgopts->gradation<1) ISSMERROR("'gradation' option should be >=1");
	for (i=0;i<bamgopts->numfields;i++) {if (bamgopts->err[i]<=0) ISSMERROR("'err' option should be >0");};

}
