/*!\file Result.cpp
 * \brief: implementation of the Result object
 */


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./Result.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../include/macros.h"
#include "./ParameterInputs.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION Result::constructor {{{1*/
Result::Result(){
	return;
}
/*}}}1*/
/*FUNCTION Result::destructor {{{1*/
Result::~Result(){
	xfree((void**)&fieldname);
	VecFree(&field);
	xfree((void**)&dfield);
	xfree((void**)&cfield);
}
/*}}}1*/
/*FUNCTION Result::Result(const Result& result) {{{1*/
Result::Result(const Result& result){

	id=result.id;
	time=result.time;
	step=result.step;
	size=result.size;
	
	/*copy constructor: copy dynamically allocated fields: */
	if(result.fieldname){
		fieldname=(char*)xmalloc((strlen(result.fieldname)+1)*sizeof(char));
		strcpy(fieldname,result.fieldname);
	}
	if(result.field){
		VecDuplicatePatch(&field,result.field);
		dfield=NULL;
		cfield=NULL;
	}
	if(result.dfield){
		dfield=(double*)xmalloc(result.size*sizeof(double));
		memcpy(dfield,result.dfield,result.size*sizeof(double));
		field=NULL;
		cfield=NULL;
	}
	if(result.cfield){
		cfield=(char*)xmalloc((strlen(result.cfield)+1)*sizeof(char));
		strcpy(cfield,result.cfield);
		field=NULL;
		dfield=NULL;
	}
}
/*}}}1*/
/*FUNCTION Result::Result(int result_id,double result_time,int result_step,char* result_fieldname,Vec result_field) {{{1*/
Result::Result(int result_id,double result_time,int result_step,char* result_fieldname,Vec result_field){

	id=result_id;
	time=result_time;
	step=result_step;
	
	if(!result_fieldname){
		ISSMERROR("NULL fieldname in constructor argument");
	}
	else{
		fieldname=(char*)xmalloc((strlen(result_fieldname)+1)*sizeof(char));
		strcpy(fieldname,result_fieldname);
	}

	VecDuplicatePatch(&field,result_field);
	dfield=NULL;
	cfield=NULL;
}
/*}}}1*/
/*FUNCTION Result::Result(int result_id,double result_time,int result_step,char* result_fldname,double* result_field,int result_size){{{1*/
Result::Result(int result_id,double result_time,int result_step,char* result_fieldname,double* result_field,int result_size){

	id=result_id;
	time=result_time;
	step=result_step;
	
	if(!result_fieldname){
		ISSMERROR(" NULL fieldname in constructor argument");
	}
	else{
		fieldname=(char*)xmalloc((strlen(result_fieldname)+1)*sizeof(char));
		strcpy(fieldname,result_fieldname);
	}

	dfield=(double*)xmalloc(result_size*sizeof(double));
	memcpy(dfield,result_field,result_size*sizeof(double));
	size=result_size;
	field=NULL;
	cfield=NULL;
}
/*}}}1*/
/*FUNCTION Result::Result(int result_id,double result_time,int result_step,char* result_fieldname,char* result_field) {{{1*/
Result::Result(int result_id,double result_time,int result_step,char* result_fieldname,char* result_field){

	id=result_id;
	time=result_time;
	step=result_step;
	
	if(!result_fieldname){
		ISSMERROR(" NULL fieldname in constructor argument");
	}
	else{
		fieldname=(char*)xmalloc((strlen(result_fieldname)+1)*sizeof(char));
		strcpy(fieldname,result_fieldname);
	}
	cfield=(char*)xmalloc((strlen(result_field)+1)*sizeof(char));
	strcpy(cfield,result_field);

	field=NULL;
	dfield=NULL;
}
/*}}}1*/
		
/*Object marshall*/
/*FUNCTION Result::Marshall {{{1*/
void  Result::Marshall(char** pmarshalled_dataset){

	ISSMERROR(" not supported yet!");

}
/*}}}1*/
/*FUNCTION Result::MarshallSize {{{1*/
int   Result::MarshallSize(){

	ISSMERROR(" not supported yet!");
}
/*}}}1*/
/*FUNCTION Result::Demarshall {{{1*/
void  Result::Demarshall(char** pmarshalled_dataset){

	ISSMERROR(" not supported yet!");
}
/*}}}1*/

/*Object functions*/
/*FUNCTION Result::copy {{{1*/
Object* Result::copy() {
	return new Result(*this); 
}
/*}}}1*/
/*FUNCTION Result::DeepEcho {{{1*/
void Result::DeepEcho(void){

	printf("Result:\n");
	printf("   id: %i\n",id);
	printf("   time: %g\n",time);
	printf("   step: %i\n",step);
	printf("   field name: %s\n",fieldname);
	if(field){
		printf("   field pointer %p\n",field);
	}
	if(dfield){
		printf("   field pointer %p\n",dfield);
		printf("   field size %i\n",size);
	}
	if(cfield){
		printf("   field pointer %p\n",cfield);
		printf("   field string %s\n",cfield);
	}
}	
/*}}}1*/
/*FUNCTION Result::Echo {{{1*/
void Result::Echo(void){

	printf("Result:\n");
	printf("   id: %i\n",id);
	printf("   time: %g\n",time);
	printf("   step: %i\n",step);
	printf("   field name: %s\n",fieldname);
	if(field){
		printf("   field pointer %p\n",field);
	}
	if(dfield){
		printf("   field pointer %p\n",dfield);
		printf("   field size %i\n",size);
	}
	if(cfield){
		printf("   field pointer %p\n",cfield);
		printf("   field string %s\n",cfield);
	}
}
/*}}}1*/
/*FUNCTION Result::Enum {{{1*/
int Result::Enum(void){

	return ResultEnum;

}
/*}}}1*/
/*FUNCTION Result::GetFieldName {{{1*/
char*    Result::GetFieldName(){
	return fieldname;
}
/*}}}1*/
/*FUNCTION Result::GetField(Vec* pfield) {{{1*/
void  Result::GetField(Vec* pfield){

	VecDuplicatePatch(pfield,field);

}
/*}}}1*/
/*FUNCTION Result::GetField(char** pcfield) {{{1*/
void  Result::GetField(char** pcfield){

	char* string=NULL;

	string=(char*)xmalloc((strlen(cfield)+1)*sizeof(char));
	strcpy(string,cfield);

	*pcfield=string;
}
/*}}}1*/
/*FUNCTION Result::GetField(double** pfield) {{{1*/
void  Result::GetField(double** pfield){
	*pfield=(double*)xmalloc(size*sizeof(double));
	memcpy(*pfield,dfield,size*sizeof(double));
}
/*}}}1*/
/*FUNCTION Result::GetId {{{1*/
int    Result::GetId(void){ return id; }
/*}}}1*/
/*FUNCTION Result::GetName {{{1*/
char* Result::GetName(void){
	return "result";
}
/*}}}1*/
/*FUNCTION Result::GetStep {{{1*/
int    Result::GetStep(){
	return step;
}
/*}}}1*/
/*FUNCTION Result::GetTime {{{1*/
double Result::GetTime(){
	return time;
}
/*}}}1*/
/*FUNCTION Result::MyRank {{{1*/
int    Result::MyRank(void){ 
	extern int my_rank;

	return my_rank; 
}
/*}}}1*/
/*FUNCTION Result::WriteData {{{1*/
void   Result::WriteData(FILE* fid){

	int length;
	int type;

	/*First write field name :*/
	length=(strlen(fieldname)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(fieldname,length,1,fid);

	/*Now write time and step: */
	fwrite(&time,sizeof(double),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*Now write field: */
	if(dfield){
		type=1;
		fwrite(&type,sizeof(int),1,fid);
		fwrite(&size,sizeof(int),1,fid);
		fwrite(dfield,size*sizeof(double),1,fid);
	}
	if(cfield){
		type=2;
		fwrite(&type,sizeof(int),1,fid);
		length=(strlen(cfield)+1)*sizeof(char);
		fwrite(&length,sizeof(int),1,fid);
		fwrite(cfield,length,1,fid);
	}
}
/*}}}1*/
