/*!\file NodeProperties.c
 * \brief: implementation of the NodeProperties object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./NodeProperties.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../DataSet/DataSet.h"
#include "../include/typedefs.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION NodeProperties default constructor {{{1*/
NodeProperties::NodeProperties(){
	
	/*initialize to UNDEF every value: */
	this->onbed=UNDEF;
	this->onsurface=UNDEF;
	this->onshelf=UNDEF;
	this->onsheet=UNDEF;
}
/*}}}*/
/*FUNCTION NodeProperties constructor {{{1*/
NodeProperties::NodeProperties(int nodeproperties_onbed, int nodeproperties_onsurface, int nodeproperties_onshelf, int nodeproperties_onsheet){
	this->Init(nodeproperties_onbed, nodeproperties_onsurface, nodeproperties_onshelf, nodeproperties_onsheet);

}
/*}}}*/
/*FUNCTION NodeProperties Init: used by constructor {{{1*/
void NodeProperties::Init(int nodeproperties_onbed, int nodeproperties_onsurface, int nodeproperties_onshelf, int nodeproperties_onsheet){

	this->onbed=nodeproperties_onbed;
	this->onsurface=nodeproperties_onsurface;
	this->onshelf=nodeproperties_onshelf;
	this->onsheet=nodeproperties_onsheet;

}
/*}}}*/
/*FUNCTION NodeProperties Init from iomodel: used by constructor {{{1*/
void NodeProperties::Init(int i, IoModel* iomodel){ //i is the node index

	if (iomodel->gridonbed)      this->onbed=(int)iomodel->gridonbed[i];
	if (iomodel->gridonsurface)  this->onsurface=(int)iomodel->gridonsurface[i];
	if (iomodel->gridoniceshelf) this->onshelf=(int)iomodel->gridoniceshelf[i];
	if (iomodel->gridonicesheet) this->onsheet=(int)iomodel->gridonicesheet[i];

}
/*}}}*/
/*FUNCTION NodeProperties copy constructor{{{1*/
NodeProperties::NodeProperties(NodeProperties* prop){ //copy constructor
	
	this->onbed=prop->onbed;
	this->onsurface=prop->onsurface;
	this->onshelf=prop->onshelf;
	this->onsheet=prop->onsheet;

}
/*}}}*/
/*FUNCTION NodeProperties destructor {{{1*/
NodeProperties::~NodeProperties(){ //destructor
}
/*}}}*/
/*FUNCTION NodeProperties Marshall{{{1*/
void  NodeProperties::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;
	int   nill=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of NodeProperties: */
	enum_type=NodePropertiesEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	memcpy(marshalled_dataset,&onbed,sizeof(onbed));marshalled_dataset+=sizeof(onbed);
	memcpy(marshalled_dataset,&onsurface,sizeof(onsurface));marshalled_dataset+=sizeof(onsurface);
	memcpy(marshalled_dataset,&onshelf,sizeof(onshelf));marshalled_dataset+=sizeof(onshelf);
	memcpy(marshalled_dataset,&onsheet,sizeof(onsheet));marshalled_dataset+=sizeof(onsheet);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION NodeProperties MarshallSize{{{1*/
int NodeProperties::MarshallSize(){

	return sizeof(onbed)+
		sizeof(onsurface)+
		sizeof(onshelf)+
		sizeof(onsheet)+
		sizeof(int); //sizeof(int) for enum type

}
/*}}}*/
/*FUNCTION NodeProperties Demarshall{{{1*/
void  NodeProperties::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;
	int   enum_type;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of object since NodeProperties is not directly called by DataSet: */
	memcpy(&enum_type,marshalled_dataset,sizeof(int)); marshalled_dataset+=sizeof(int);

	memcpy(&onbed,marshalled_dataset,sizeof(onbed));marshalled_dataset+=sizeof(onbed);
	memcpy(&onsurface,marshalled_dataset,sizeof(onsurface));marshalled_dataset+=sizeof(onsurface);
	memcpy(&onshelf,marshalled_dataset,sizeof(onshelf));marshalled_dataset+=sizeof(onshelf);
	memcpy(&onsheet,marshalled_dataset,sizeof(onsheet));marshalled_dataset+=sizeof(onsheet);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*FUNCTION NodeProperties Echo{{{1*/
void  NodeProperties::Echo(void){

	printf("Node properties:\n");
	printf("   onbed: %i\n",onbed);
	printf("   onsurface: %i\n",onsurface);
	printf("   onshelf: %i\n",onshelf);
	printf("   onsheet: %i\n",onsheet);
}
/*}}}*/
/*FUNCTION NodeProperties DeepEcho{{{1*/
void  NodeProperties::DeepEcho(void){
	this->Echo();
}
/*}}}*/
