/*!\file: slopecompute_core.cpp
 * \brief: core of the slopecompute solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./parallel.h"
#include "../issm.h"

void slopecompute_core(DataSet* results,Model* model,ParameterInputs* inputs){

	extern int my_rank;

	/*output: */
	Result* result=NULL;

	/*solutions: */
	Vec sx_g=NULL;
	Vec sy_g=NULL;

	/*flags: */
	int verbose=0;
	int numberofdofspernode;
	int numberofnodes;
	int dofs[2]={1,1};

	/*fem slopecompute model: */
	FemModel* fem_sl=NULL;

	/*recover fem model: */
	fem_sl=model->GetFormulation(SlopecomputeAnalysisEnum);

	//first recover parameters common to all solutions
	model->FindParam(&verbose,"verbose");
	model->FindParam(&numberofnodes,"numberofnodes");
	model->FindParam(&numberofdofspernode,"numberofdofspernode");

	_printf_("call computational core:\n");
	diagnostic_core_linear(&sx_g,fem_sl,inputs,SlopecomputeAnalysisEnum,SurfaceXAnalysisEnum);
	diagnostic_core_linear(&sy_g,fem_sl,inputs,SlopecomputeAnalysisEnum,SurfaceYAnalysisEnum);

	_printf_("extrude computed slope on all layers:\n");
	FieldExtrudex( sx_g, fem_sl->elements,fem_sl->nodes, fem_sl->vertices,fem_sl->loads, fem_sl->materials,fem_sl->parameters,"slopex",0);
	FieldExtrudex( sy_g, fem_sl->elements,fem_sl->nodes, fem_sl->vertices,fem_sl->loads, fem_sl->materials,fem_sl->parameters,"slopey",0);

	/*Plug results into output dataset: */
	result=new Result(results->Size()+1,0,1,"sx_g",sx_g);
	results->AddObject(result);
	result=new Result(results->Size()+1,0,1,"sy_g",sy_g);
	results->AddObject(result);

	/*Free ressources:*/
	VecFree(&sx_g);
	VecFree(&sy_g);
}
