
/*!\file: ControlRestart.cpp
 * \brief: core of the control solution 
 */ 

#include "./parallel.h"
#include "../issm.h"

void ControlRestart(Model* model,double* param_g){

	extern int my_rank;

	/*output: */
	DataSet* temporary_results=NULL;
	DataSet* results=NULL;
	Result*  result=NULL;
	char*    outputfilename=NULL;

	/*Intermediary: */
	int      i;
	int      numberofnodes;
	double* param_g_copy;

	/*Recover parameters used throughout the solution:*/
	model->FindParam(&numberofnodes,"numberofnodes");
	model->FindParam(&outputfilename,"outputfilename");

	/*Plug COPYS of the results into output dataset: 
	 * only the pointer is given to temporary_results and at the
	 * end of ProcessResults the pointer is deleted. That would 
	 * destroy param_g*/

	param_g_copy=(double*)xcalloc(numberofnodes,sizeof(double));
	for(i=0;i<numberofnodes;i++) param_g_copy[i]=param_g[i];

	temporary_results=new DataSet(ResultsEnum); 
	result=new Result(temporary_results->Size()+1,0,1,"param_g",param_g_copy,numberofnodes);
	temporary_results->AddObject(result);
	
	result=new Result(temporary_results->Size()+1,0,1,"analysis_type","diagnostic");
	temporary_results->AddObject(result);

	//process results
	ProcessResults(&results,temporary_results,model,ControlAnalysisEnum);

	//Write results on disk
	OutputResults(results,outputfilename);
	
	/*Free ressources:*/
	delete temporary_results;
	delete results;
	xfree((void**)&outputfilename);
	xfree((void**)&param_g_copy);
}
