/*!\file Input.c
 * \brief: implementation of the Input object
 */


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"
#include "../include/macros.h"
#include "./objects.h"

		
/*Object constructors and destructor*/
/*FUNCTION Input::constructor {{{1*/
Input::Input(){
	return;
}
/*}}}*/
/*FUNCTION Input::destructor {{{1*/
Input::~Input(){

	xfree((void**)&vector);
	return;
}
/*}}}*/
/*FUNCTION Input::creation(char* input_name,int input_integer) {{{1*/
Input::Input(char* input_name,int input_integer){

	strcpy(name,input_name);
	type=INTEGER;
	integer=input_integer;

	ndof=0;
	numberofnodes=0;
	vector=NULL;
}
/*}}}*/
/*FUNCTION Input::creation(char* input_name,double input_scalar) {{{1*/
Input::Input(char* input_name,double input_scalar){

	strcpy(name,input_name);
	type=DOUBLE;
	scalar=input_scalar;

	ndof=0;
	numberofnodes=0;
	vector=NULL;

}
/*}}}*/
/*FUNCTION Input::creation(char* input_name,char* input_string) {{{1*/
Input::Input(char* input_name,char* input_string){
	
	strcpy(name,input_name);
	type=STRING;
	strcpy(string,input_string);
	ndof=0;
	numberofnodes=0;
	vector=NULL;
}
/*}}}*/
/*FUNCTION Input::creation(char* input_name,double* input_vector,int input_ndof,int input_numberofnodes) {{{1*/
Input::Input(char* input_name,double* input_vector,int input_ndof,int input_numberofnodes){

	strcpy(name,input_name);
	type=DOUBLEVEC;
	vector=(double*)xmalloc(input_ndof*input_numberofnodes*sizeof(double));
	memcpy(vector,input_vector,input_ndof*input_numberofnodes*sizeof(double));
	ndof=input_ndof;
	numberofnodes=input_numberofnodes;

}
/*}}}*/
/*FUNCTION Input::creation(char* input_name,Vec input_vector,int input_ndof, int input_numberofnode) {{{1*/
Input::Input(char* input_name,Vec input_vector,int input_ndof, int input_numberofnodes){

	strcpy(name,input_name);
	type=DOUBLEVEC;
	VecToMPISerial(&vector,input_vector);
	ndof=input_ndof;
	numberofnodes=input_numberofnodes;

}
/*}}}*/

/*Object marshall*/
/*FUNCTION Input::Demarshall {{{1*/
void  Input::Demarshall(char** pmarshalled_dataset){
	ISSMERROR("not supported yet!");
}
/*}}}*/
/*FUNCTION Input::Marshall {{{1*/
void  Input::Marshall(char** pmarshalled_dataset){
	ISSMERROR("not supported yet!");
}
/*}}}*/
/*FUNCTION Input::MarshallSize {{{1*/
int   Input::MarshallSize(){
	ISSMERROR("not supported yet!");
}
/*}}}*/

/*Object functions*/
/*FUNCTION Input::copy {{{1*/
Object* Input::copy() {
	
	return new Input(*this); 

}
/*}}}*/
/*FUNCTION Input::DeepEcho {{{1*/
void Input::DeepEcho(void){

	int i,j;
	
	printf("Input:\n");
	printf("   name: %s\n",name);
	printf("   type: %i\n",type);
	if(type==STRING) printf("   string: %s\n",string);
	if(type==INTEGER) printf("   integer: %i\n",integer);
	if(type==DOUBLE) printf("   double: %g\n",scalar);
	if(type==DOUBLEVEC) printf("   doublevec:\n");
	for(i=0;i<numberofnodes;i++){
		printf("      node %i: ",i);
		for(j=0;j<ndof;j++)printf("%g ",*(vector+i*ndof+j));
		printf("\n");
	}
}		
/*}}}*/
/*FUNCTION Input::Echo {{{1*/
void Input::Echo(void){

	int i,j;
	
	printf("Input:\n");
	printf("   name: %s\n",name);
	printf("   type: %i\n",type);
	if(type==STRING) printf("   string: %s\n",string);
	if(type==INTEGER) printf("   integer: %i\n",integer);
	if(type==DOUBLE) printf("   double: %g\n",scalar);
	if(type==DOUBLEVEC) printf("   doublevec:%p\n",vector);
}
/*}}}*/
/*FUNCTION Input::Enum {{{1*/
int Input::Enum(void){

	return InputEnum;

}
/*}}}*/
/*FUNCTION Input::Get {{{1*/
Vec   Input::Get(int* in_dofs, int in_numdofs){

	int i,j;
	int index;
	double value;
	extern int my_rank;
	int count=0;
	int i0,i1;

	/*output: */
	Vec outvector=NULL;
	int totaldofs=0;

	if (type!=DOUBLEVEC)ISSMERROR(" trying to recover Petsc vector on non DOUBLEVEC entity!");

	/*figure out how many dofs are requested: */
	totaldofs=0;
	for(i=0;i<in_numdofs;i++)totaldofs+=in_dofs[i];
	
	/*Allocate outvector: */
	outvector=NewVec(totaldofs*numberofnodes);

	i0=MPI_Lowerrow(numberofnodes);
	i1=MPI_Upperrow(numberofnodes);

	for(i=i0;i<i1;i++){
		count=0;
		for(j=0;j<in_numdofs;j++){
			if (in_dofs[j]){
				index=i*totaldofs+count;
				value=vector[i*ndof+j];
				VecSetValues(outvector,1,&index,&value,INSERT_VALUES);
				count++;
			}
		}
	}

	/*Assmeble: */
	VecAssemblyBegin(outvector);
	VecAssemblyEnd(outvector);


	return outvector;
}
/*}}}*/
/*FUNCTION Input::GetId {{{1*/
int   Input::GetId(){
	ISSMERROR("not supported yet!");
}
/*}}}*/
/*FUNCTION Input::GetName {{{1*/
char* Input::GetName(){
	ISSMERROR("not supported yet!");
}
/*}}}*/
/*FUNCTION Input::IsPresent {{{1*/
int   Input::IsPresent(char* input_name){
	if (strcmp(input_name,name)==0) return 1;
	else return 0;
}
/*}}}*/
/*FUNCTION Input::IsSameName {{{1*/
int   Input::IsSameName(char* input_name){
	if (strcmp(input_name,name)==0)return 1;
	else return 0;
}
/*}}}*/
/*FUNCTION Input::MyRank {{{1*/
int    Input::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION Input::Recover(double* valuesin, int ndofin, int* dofsin,int numnodesin,void** vpnodesin) {{{1*/
void  Input::Recover(double* valuesin, int ndofin, int* dofsin,int numnodesin,void** vpnodesin){

	//ex: 
	// double values[6];
	// int ndof=2;
	// int dofs[2]={0,2}    //dofs 0 and 2
	// for a tria, 3 nodes
	//input->Recover(&values[0],ndof,dofs,3,this->nodes); //ie: recover values for dofs 0 and 2 of all nodes of the tria

	int* doflist=NULL;
	int  dof1;
	int  dof;
	int  i,j;
	
	Node** nodes=NULL;
	Node* node=NULL;

	/*recover pointer to nodes: */
	nodes=(Node**)vpnodesin;
	
	if (!valuesin) ISSMERROR("valuesin has not been allocated properly (pointer is NULL)");
	if (type!=DOUBLEVEC) ISSMERROR(exprintf("%s%i%s"," cannot recover values from a ",type," input type"));
	
	/*Ok, we are trying to fill values. values is of size ndof*numnodes.  The dofs 
	 * for picking up the values are found in the numnodes nodes. We firt build the dof list: */
	doflist=(int*)xmalloc(ndofin*numnodesin*sizeof(int));

	for(i=0;i<numnodesin;i++){
		node=nodes[i];

		/*Get 1d dof of this node: */
		dof1=node->GetDofList1();

		for(j=0;j<ndofin;j++){
			dof=dofsin[j];
			doflist[i*ndofin+j]=dof1*ndof+dof;
		}
	}
	
	for(i=0;i<ndofin*numnodesin;i++){
		ISSMASSERT(doflist[i]<ndof*numberofnodes);
		valuesin[i]=vector[doflist[i]];
	}

	xfree((void**)&doflist);
}
/*}}}*/
/*FUNCTION Input::Recover(int* pinteger) {{{1*/
void  Input::Recover(int* pinteger){
	*pinteger=integer;
}
/*}}}*/
/*FUNCTION Input::Recover(double* pdouble) {{{1*/
void  Input::Recover(double* pdouble){

	*pdouble=scalar;

}
/*}}}*/
/*FUNCTION Input::Recover(char** pstring) {{{1*/
void  Input::Recover(char** pstring){
	char* outstring=NULL;

	outstring=(char*)xmalloc((strlen(string)+1)*sizeof(char));
	strcpy(outstring,string);
	*pstring=outstring;

}
/*}}}*/
