/*! \file CreateLoadsMelting.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../IoModel.h"

void	CreateLoadsMelting(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i;
	int count=0;

	DataSet*    loads    = NULL;

	/*if 2d: return*/
	if (strcmp(iomodel->meshtype,"2d")==0)goto cleanup_and_return;

	/*Create loads: */
	loads   = new DataSet(LoadsEnum);

	//create penalties for grids: no grid can have a temperature over the melting point
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");

	count=1; //matlab indexing
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){

			if (iomodel->gridonbed[i]){ 

				loads->AddObject( new Pengrid(count+1, i+1,iomodel->numberofelements+1, 1, 0, iomodel->penalty_offset, 1, iomodel->stabilize_constraints));
				count++;
			}
		} //if((iomodel->my_vertices[i]==1))
	}
	xfree((void**)&iomodel->gridonbed);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*ploads=loads;

}


