function [value]=MassFlux(md)


%ok, go around the domain outline, pick up the md.segments, build the normals, and 
%then add normals * thickness * velocity * length segment

length=sqrt( (md.x(md.segments(:,1))-md.x(md.segments(:,2))).^2 + (md.y(md.segments(:,1))-md.y(md.segments(:,2))).^2 );
normal(:,1)=cos(atan2( (md.x(md.segments(:,1))-md.x(md.segments(:,2))) , (md.y(md.segments(:,2))-md.y(md.segments(:,1))) ) );
normal(:,2)=sin(atan2( (md.x(md.segments(:,1))-md.x(md.segments(:,2))) , (md.y(md.segments(:,2))-md.y(md.segments(:,1))) ) );

thickness=md.thickness(md.segments(:,1:2))*[1;1]/2;
vx=md.vx(md.segments(:,1:2))*[1;1]/2;
vy=md.vy(md.segments(:,1:2))*[1;1]/2;

value=sum(md.rho_ice.*thickness.*length.*(normal(:,1).*vx+normal(:,2).*vy));
