function fields=testsgetfields(md,sequence),
%TESTSGETFIELDS - build the fields to be checked from a analysis
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input analysis 'prognostic', it will output 'prognostic.thickness'
%
%   Usage:
%      fields=testsgetfields(md,analysis)
%
%   Example:
%      fields=testsgetfields(md,'diagnostic')
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE

%recover what is being requested.
analysis_type=sequence{1};
sub_analysis_type=sequence{2};
qmu=sequence{3};
control=sequence{4};
control_fit=sequence{5};
parallel=sequence{6};

if strcmpi(analysis_type,'diagnostic'),
	if control,
		fields={'diagnostic.vel','diagnostic.J','diagnostic.parameter'};
	elseif qmu,
		fields={'dakota.importancefactors'};
	else
		if strcmpi(md.type,'3d')
			fields={'diagnostic.vy','diagnostic.vz'};
		else
			fields={'diagnostic.vel'};
		end
	end

elseif strcmpi(analysis_type,'thermal'),
	fields={'thermal(end).temperature','thermal(end).melting'};

elseif strcmpi(analysis_type,'prognostic'),
	fields={'prognostic.thickness'};

elseif strcmpi(analysis_type,'transient'), 
	if strcmpi(md.type,'3d')
		fields={'transient(end).vel','transient(end).pressure','transient(end).temperature','transient(end).melting','transient(end).thickness','transient(end).surface','transient(end).bed'};
	else
		fields={'transient(end).vel','transient(end).thickness','transient(end).surface','transient(end).bed'};
	end

elseif strcmpi(analysis_type,'steadystate'), 
	if control,
		fields={'steadystate.vel','steadystate.J','steadystate.parameter'};
	else
		fields={'steadystate.vel','steadystate.pressure','steadystate.temperature'};
	end

elseif strcmpi(analysis_type,'balancedthickness'), 
	fields={'balancedthickness.thickness'};

elseif strcmpi(analysis_type,'slopecompute'), 
	fields={'slopecompute.slopex','slopecompute.slopey'};

else
	error(['testsgetfields error message: requested sequence not supported yet']);
end
