/*\file ComputePressure.c
 *\brief: recover pressure from elements
 */

#include "./ComputePressure.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL; 
	DataSet* vertices=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	DataSet* parameters=NULL;
	ParameterInputs* inputs=NULL;
	int      numberofnodes;
	int      analysis_type;
	int      sub_analysis_type;

	/* output datasets: */
	Vec p_g=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ComputePressureUsage);
        
	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&analysis_type,ANALYSIS);
	FetchData(&sub_analysis_type,SUBANALYSIS);

	/*!Generate internal degree of freedom numbers: */
	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);

	UpdateFromInputsx(elements,nodes,vertices,loads, materials,parameters,inputs);

	/*!Generate internal degree of freedom numbers: */
	ComputePressurex(&p_g, elements,nodes,vertices,loads,materials,parameters,inputs,analysis_type,sub_analysis_type);

	/*write output datasets: */
	WriteData(PRESSURE,p_g);

	/*Free ressources: */
	delete nodes;
	delete vertices;
	delete elements;
	delete materials;
	delete loads;
	delete parameters;
	delete inputs;
	VecFree(&p_g);

	/*end module: */
	MODULEEND();
}

void ComputePressureUsage(void) {
	printf("\n");
	printf("   usage: [p_g] = %s(elements, nodes, vertices, loads, materials, params,inputs);\n",__FUNCT__);
	printf("\n");
}
