/*!\file:  Element.h
 * \brief abstract class for Element object
 * This class is a place holder for the Tria and the Penta elements. 
 * It is derived from Element, so DataSets can contain them.
 */ 


#ifndef _ELEMENT_H_
#define _ELEMENT_H_

#include "./Object.h"
#include "../toolkits/toolkits.h"

class Element: public Object{

	public: 
		
		virtual        ~Element(){};
		virtual void   Configure(void* loads,void* nodes,void* materials,void* parameters)=0;
		virtual void   CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual void   CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type)=0;
		virtual void   UpdateFromInputs(void* inputs)=0;
		virtual void   GetNodes(void** nodes)=0;
		virtual void*  GetMatPar()=0;
		virtual int    GetShelf()=0; 
		virtual int    GetOnBed()=0;
		virtual void   GetThicknessList(double* thickness_list)=0;
		virtual void   GetBedList(double* bed_list)=0;
		virtual void   Du(Vec du_g,void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual void   Gradj(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type,char* control_type)=0;
		virtual void   GradjDrag(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual void   GradjB(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual double Misfit(void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual double CostFunction(void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual double SurfaceArea(void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual void   ComputeBasalStress(Vec sigma_b,void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual void   ComputePressure(Vec p_g,       void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual void   ComputeStrainRate(Vec eps,     void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual double MassFlux(double* segment,double* ug)=0;

		/*Implementation: */
		int            Enum();

		
};
#endif
