/*!\file ComputeStrainRatex
 * \brief: compute pressure according to each element
 */

#include "./ComputeStrainRatex.h"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void	ComputeStrainRatex( Vec* peps,DataSet* elements,DataSet* nodes, DataSet* vertices,DataSet* loads, DataSet* materials,DataSet* parameters,
			ParameterInputs* inputs,int analysis_type,int sub_analysis_type){

	int i;

	int  found=0;
	double numberofelements;

	/*output: */
	Vec eps=NULL;

	/*Recover numberofelements: */
	parameters->FindParam(&numberofelements,"numberofelements");

	/*Allocate eps on numberofelements (only 1 dof): */
	eps=NewVec(numberofelements);

	/*Get elements configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Call on dataset driver: */
	elements->ComputeStrainRate(eps,inputs,analysis_type,sub_analysis_type);

	/*Assemble vector: */
	VecAssemblyBegin(eps);
	VecAssemblyEnd(eps);

	/*Assign output pointers: */
	*peps=eps;
	
}
