/*!\file ComputePressurex
 * \brief: compute pressure according to each element
 */

#include "./ComputePressurex.h"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void	ComputePressurex( Vec* pp_g,DataSet* elements,DataSet* nodes, DataSet* vertices,DataSet* loads, DataSet* materials,DataSet* parameters,
			ParameterInputs* inputs,int analysis_type,int sub_analysis_type){

	int i;

	int  found=0;
	double numberofnodes;

	/*output: */
	Vec p_g=NULL;

	/*Recover numberofnodes: */
    parameters->FindParam(&numberofnodes,"numberofnodes");

	/*Allocate p_g on numberofnodes (only 1 dof): */
	p_g=NewVec(numberofnodes);

	/*Get elements configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Call on dataset driver: */
	elements->ComputePressure(p_g,inputs,analysis_type,sub_analysis_type);

	/*Assemble vector: */
	VecAssemblyBegin(p_g);
	VecAssemblyEnd(p_g);

	/*Assign output pointers: */
	*pp_g=p_g;
	
}
