function [loads,converged]=PenaltyConstraints(loads,grids,materials,params,inputs)
%PENALTYCONSTRAINTS - test if the thermal solution has converged
%
%   This routine check if each element have converged in term of penalty activation
%   once all the penalties remain the same between 2 iterations, return converged=1
%
%   Usage:
%      [loads,converged]=PenaltyConstraints(loads,grids,materials,params,inputs)

min_thermal_constraints=params.min_thermal_constraints;
unstable_count=0;

%Go through constraints and set active flags
for n=1:length(loads), 
	[loads(n).load unstable]=PenaltyConstrain(loads(n).load,grids,materials,inputs);
	unstable_count=unstable_count+unstable;
end

disp(sprintf('%s %g','      number of unstable melting constraints: ',unstable_count));

if unstable_count<=min_thermal_constraints,
	converged=1;
else
	converged=0;
end
