function results=slopecompute_core(models,inputs,analysis_type,sub_analysis_type)
%SLOPECOMPUTE_CORE - linear solution sequence
%
%   Usage:
%      [sx_g sy_g]=slopecompute_core(m,inputs,analysis_type,sub_analysis_type)

	%get FE model
	m=models.sl;
	results.time=0;
	results.step=1;

	displaystring(m.parameters.verbose,'\n%s',['call computational core:']);
	results.sx_g=diagnostic_core_linear(m,inputs,analysis_type,SurfaceXAnalysisEnum());
	results.sy_g=diagnostic_core_linear(m,inputs,analysis_type,SurfaceYAnalysisEnum());

	displaystring(m.parameters.verbose,'\n%s',['extrude computed slope on all layers:']);
	results.sx_g=FieldExtrude(m.elements,m.nodes,m.vertices,m.loads,m.materials,m.parameters,results.sx_g,'slopex',0);
	results.sy_g=FieldExtrude(m.elements,m.nodes,m.vertices,m.loads,m.materials,m.parameters,results.sy_g,'slopey',0);

end %end function
