function u_g=diagnostic_core_linear(m,inputs,analysis_type,sub_analysis_type)
%DIAGNOSTIC_CORE_LINEAR - linear solution sequence
%
%   Usage:
%      u_g=diagnostic_core_linear(m,inputs,analysis_type,sub_analysis_type)

	%stiffness and load generation only:
	m.parameters.kflag=1; m.parameters.pflag=1;

	disp('file: diagnostic_core_linear.m  ok0');

	%Update inputs in datasets
	[m.elements,m.nodes,m.vertices,m.loads,m.materials,m.parameters]=UpdateFromInputs(m.elements,m.nodes,m.vertices,m.loads,m.materials,m.parameters,inputs);
	
	disp('file: diagnostic_core_linear.m  ok1');

	%system matrices
	[K_gg, p_g]=SystemMatrices(m.elements,m.nodes,m.vertices,m.loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
	disp('file: diagnostic_core_linear.m  ok2');

	[K_gg, p_g,kmax]=PenaltySystemMatrices(K_gg,p_g,m.elements,m.nodes,m.vertices,m.loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
	disp('file: diagnostic_core_linear.m  ok3');

	
	%Reduce tangent matrix from g size to f size
	[K_ff, K_fs] = Reducematrixfromgtof( K_gg, m.Gmn, m.nodesets); 
	displaystring(m.parameters.verbose>1,'%s%g','      condition number of stiffness matrix: ',condest(K_ff));
	
	%Reduce load from g size to f size
	[p_f] = Reduceloadfromgtof( p_g, m.Gmn, K_fs, m.ys, m.nodesets);
	
	%Solve	
	[u_f]=Solver(K_ff,p_f,[],m.parameters);
	
	%Merge back to g set
	[u_g]= Mergesolutionfromftog( u_f, m.Gmn, m.ys, m.nodesets ); 

end %end function
