function [t_g ,loads, melting_offset]=thermal_core_nonlinear(m,inputs,analysis_type,sub_analysis_type)
%THERMAL_CORE_NONLINEAR - core of thermal solution sequence.
%   model is return together with temperature
%
%
%   Usage:
%      [t_g ,loads, melting_offset]=thermal_core_nonlinear(m,inputs,analysis_type,sub_analysis_type);
%    
%      

	count=1;
	converged=0;

%   we are going to return the loads, make them a variable of this routine
	loads=m.loads;

	%stiffness and load generation only:
	m.parameters.kflag=1; m.parameters.pflag=1;

	displaystring(m.parameters.verbose,'\n%s',['   starting direct shooting method']);
	
	while(~converged),

		%Update inputs in datasets
		[m.elements,m.nodes,m.vertices,loads,m.materials,m.parameters]=UpdateFromInputs(m.elements,m.nodes,m.vertices, loads,m.materials,m.parameters,inputs);

		%system matrices 
		if ~m.parameters.lowmem 
			if count==1
				displaystring(m.parameters.verbose,'%s',['   system matrices']);
				[K_gg_nopenalty, p_g_nopenalty]=SystemMatrices(m.elements,m.nodes,m.vertices,loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
			end
			displaystring(m.parameters.verbose,'%s',['   penalty system matrices']);
			[K_gg , p_g, melting_offset]=PenaltySystemMatrices(K_gg_nopenalty,p_g_nopenalty,m.elements,m.nodes,m.verticesloads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
		else
			displaystring(m.parameters.verbose,'%s',['   system matrices']);
			[K_gg , p_g]=SystemMatrices(m.elements,m.nodes,m.vertices,loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
			displaystring(m.parameters.verbose,'%s',['   penalty system matrices']);
			[K_gg , p_g, melting_offset]=PenaltySystemMatrices(K_gg,p_g,m.elements,m.nodes,m.vertices,loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
		end

		%Reduce tangent matrix from g size to f size
		[K_ff, K_fs] = Reducematrixfromgtof( K_gg, m.Gmn, m.nodesets); 

		%Reduce load from g size to f size
		[p_f] = Reduceloadfromgtof( p_g, m.Gmn, K_fs, m.ys, m.nodesets);

		%Solve	
		displaystring(m.parameters.verbose,'%s%g','   condition number of stiffness matrix: ',condest(K_ff));
		[t_f]=Solver(K_ff,p_f,[],m.parameters);

		%Merge back to g set
		displaystring(m.parameters.verbose,'%s',['   merging solution back to g set']);
		[t_g]= Mergesolutionfromftog( t_f, m.Gmn, m.ys, m.nodesets ); 

		%Update inputs in datasets
		inputs=add(inputs,'temperature',t_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);
		displaystring(m.parameters.verbose,'%s',['   update inputs']);
		[m.elements,m.nodes,m.vertices, loads,m.materials,m.parameters]=UpdateFromInputs(m.elements,m.nodes,m.vertices, loads,m.materials,m.parameters,inputs);
	
		%penalty constraints
		displaystring(m.parameters.verbose,'%s',['   penalty constraints']);
		[loads,constraints_converged,num_unstable_constraints] =PenaltyConstraints(m.elements,m.nodes,m.vertices,loads, m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
	
		if ~converged,
			displaystring(m.parameters.verbose,'%s%i','   #unstable constraints ',num_unstable_constraints);
			
			if num_unstable_constraints<=m.parameters.min_thermal_constraints,
				converged=1;
			end
		end

		count=count+1;
	end

end
