/*\file SystemMatrices.c
 *\brief: build system matrices (stiffness matrix, loads vector)
 */

#include "./SystemMatrices.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* vertices=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	DataSet* parameters=NULL;
	int         kflag,pflag;
	int         connectivity;
	int         numberofdofspernode;
	ParameterInputs* inputs=NULL;
	int               analysis_type;
	int               sub_analysis_type;
	
	/* output datasets: */
	Mat Kgg=NULL;
	Vec pg=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&SystemMatricesUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	/*parameters: */
	parameters->FindParam(&kflag,"kflag");
	parameters->FindParam(&pflag,"pflag");
	parameters->FindParam(&connectivity,"connectivity");
	parameters->FindParam(&numberofdofspernode,"numberofdofspernode");

	FetchData(&analysis_type,ANALYSIS);
	FetchData(&sub_analysis_type,SUBANALYSIS);

	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);

	/*!Generate internal degree of freedom numbers: */
	SystemMatricesx(&Kgg, &pg,elements,nodes,vertices,loads,materials,parameters,kflag,pflag,connectivity,numberofdofspernode,inputs,analysis_type,sub_analysis_type); 

	/*write output datasets: */
	WriteData(KGG,Kgg);
	WriteData(PG,pg);
	
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	delete inputs;
	MatFree(&Kgg);
	VecFree(&pg);

	/*end module: */
	MODULEEND();
}

void SystemMatricesUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [Kgg,pg] = %s(elements,nodes,vertices,loads,materials,params,inputs,analysis_type);\n",__FUNCT__);
	_printf_("\n");
}
