/*!\file: ElementProperties.h
 * \brief prototype for ElementProperties.h
 */ 

#ifndef _ELEMENTPROPERTIES_H_
#define  _ELEMENTPROPERTIES_H_

/*indefinitions: */
struct IoModel;

class ElementProperties{
	
	public:

		/*nodal property values: */
		int      numnodes;
		double*  h;
		double*  s;
		double*  b;
		double*  k;
		double*  melting;
		double*  accumulation;
		double*  geothermalflux;
		
		/*element property values: */
		int     friction_type;
		double  p;
		double  q;
		int     shelf;
		int     onbed;
		bool    onwater;
		int     onsurface;
		int     collapse;
		int     thermal_steadystate;

		ElementProperties();
		ElementProperties(int numnodes, double* h, double* s, double* b, double* k, double* melting, double* accumulation, double* geothermalflux, int friction_type, double p, double q, int shelf, int onbed, bool onwater, int onsurface, int collapse, int thermal_steadystate);
		ElementProperties(ElementProperties* properties);
		~ElementProperties();

		void Init(int numnodes, int* vertex_ids, int element_id, IoModel* iomodel);
		void Init(int numnodes, double* h, double* s, double* b, double* k, double* melting, double* accumulation, double* geothermalflux, int friction_type, double p, double q, int shelf, int onbed, bool onwater, int onsurface, int collapse, int thermal_steadystate);
		
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		void  copy(ElementProperties* properties);
		void  Echo(void); 
		void  DeepEcho(void); 
		ElementProperties* Spawn(int* indices, int numindices);

};
#endif //ifndef _ELEMENTPROPERTIES_H_

		
