/*
 * CreateConstraintsDiagnosticHutter.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"

void	CreateConstraintsDiagnosticHutter(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i;
	int count=0;

	DataSet* constraints = NULL;
	Spc*    spc  = NULL;

	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!iomodel->ishutter) goto cleanup_and_return;

	/*Fetch data: */
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");

	count=1; //matlab indexing
	/*vx and vy are spc'd if we are not on gridonhutter: */
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i])){
			if (!(int)iomodel->gridonhutter[i]){

				constraints->AddObject(new Spc(count,i+1,1,0));
				count++;

				constraints->AddObject(new Spc(count,i+1,2,0));
				count++;
			}
		} //if((my_vertices[i]))
	}

	/*Free data: */
	xfree((void**)&iomodel->gridonhutter);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
