/*! \file Penta.h 
 *  \brief: header file for penta object
 */

#ifndef _PENTA_H
#define _PENTA_H

class Object;
class Node;
class Hook;
class ElementProperties;
class DataSet;
struct IoModel;


#include "./Object.h"
#include "./Element.h"
#include "./Matpar.h"
#include "./Numpar.h"
#include "./Matice.h"
#include "./Tria.h"
#include "./Hook.h"
#include "./ElementProperties.h"
#include "../ModelProcessorx/IoModel.h"
#include "./ParameterInputs.h"
#include "./Node.h"

class Penta: public Element{

	private: 

		int id;
		Hook hnodes;  //hook to 6 nodes
		Hook hmatice; //hook to 1 matice
		Hook hmatpar; //hook to 1 matpar
		Hook hnumpar; //hook to 1 numpar

		ElementProperties properties;

	public:

		/*FUNCTION constructors, destructors {{{1*/
		Penta();
		Penta(int penta_id,int* penta_node_ids, int penta_matice_id, int penta_matpar_id, int penta_numpar_id, ElementProperties* properties);
		Penta(int penta_id,Hook* penta_hnodes, Hook* penta_hmatice, Hook* penta_hmatpar, Hook* penta_hnumpar, ElementProperties* penta_properties);
		Penta(int i, IoModel* iomodel);
		~Penta();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		void  Configure(void* loads,void* nodes,void* materials,void* parameters);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   GetId(); 
		char* GetName();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void*  SpawnTria(int g0, int g1, int g2);
		void  UpdateFromDakota(void* inputs);
		void  UpdateFromInputs(void* inputs);
		void  SetClone(int* minranks);

		/*}}}*/
		/*FUNCTION element numerical routines {{{1*/
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticHoriz( Mat Kgg, void* inputs, int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticVert( Mat Kgg, void* inputs, int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void* GetMatPar();
		int   GetShelf();
		void  GetNodes(void** nodes);
		int   GetOnBed();
		void  Du(Vec du_g,void* inputs,int analysis_type,int sub_analysis_type);
		void  Gradj(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type,char* control_type);
		void  GradjDrag(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type);
		void  GradjB(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type);
		double Misfit(void* inputs,int analysis_type,int sub_analysis_type);
		double SurfaceArea(void* inputs,int analysis_type,int sub_analysis_type);
		double CostFunction(void* inputs,int analysis_type,int sub_analysis_type);
		
		void          GetThicknessList(double* thickness_list);
		void          GetBedList(double* bed_list);

		void  GetStrainRate(double* epsilon, double* velocity, double* xyz_list, double* gauss_coord);
		void  GetB(double* pB, double* xyz_list, double* gauss_coord);
		void  GetBPrime(double* B, double* xyz_list, double* gauss_coord);
		void  GetB_vert(double* B, double* xyz_list, double* gauss_coord);
		void  GetBPrime_vert(double* B, double* xyz_list, double* gauss_coord);
		void  GetJacobianDeterminant(double*  Jdet, double* xyz_list,double* gauss_coord);
		void  GetNodalFunctionsDerivatives(double* dh1dh6,double* xyz_list, double* gauss_coord);
		void  GetJacobian(double* J, double* xyz_list,double* gauss_coord);
		void  GetNodalFunctionsDerivativesReference(double* dl1dl6,double* gauss_coord);
		void  GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss_coord);
		void  CreatePVectorDiagnosticHoriz( Vec pg, void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticVert( Vec pg, void* inputs,int analysis_type,int sub_analysis_type);
		void  GetParameterValue(double* pvalue, double* v_list,double* gauss_coord);
		void  GetParameterDerivativeValue(double* p, double* p_list,double* xyz_list, double* gauss_coord);
		void  GetNodalFunctions(double* l1l6, double* gauss_coord);
		void  FieldExtrude(Vec field,double* field_serial,char* field_name, int iscollapsed);
		void  ComputePressure(Vec p_g);
		void  CreateKMatrixSlopeCompute(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorSlopeCompute( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);
		void  CreateKMatrixPrognostic(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorPrognostic( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBalancedthickness(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorBalancedthickness( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBalancedvelocities(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorBalancedvelocities( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);

		void  CreateKMatrixDiagnosticStokes( Mat Kgg, void* vinputs, int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticStokes( Vec pg, void* vinputs,int analysis_type,int sub_analysis_type);
		void  ReduceMatrixStokes(double* Ke_reduced, double* Ke_temp);
		void  GetMatrixInvert(double*  Ke_invert, double* Ke);
		void  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		void  GetStrainRateStokes(double* epsilon, double* velocity, double* xyz_list, double* gauss_coord);
		void  GetBStokes(double* B, double* xyz_list, double* gauss_coord);
		void  GetBprimeStokes(double* B_prime, double* xyz_list, double* gauss_coord);
		void  GetLStokes(double* LStokes, double* gauss_coord_tria);
		void  GetLprimeStokes(double* LprimeStokes, double* xyz_list, double* gauss_coord_tria, double* gauss_coord);
		void  GetNodalFunctionsDerivativesStokes(double* dh1dh7,double* xyz_list, double* gauss_coord);
		void  GetNodalFunctionsDerivativesReferenceStokes(double* dl1dl7,double* gauss_coord);
		void  ReduceVectorStokes(double* Pe_reduced, double* Ke_temp, double* Pe_temp);
		void  GetNodalFunctionsStokes(double* l1l7, double* gauss_coord);
		void  CreateKMatrixThermal(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  GetB_conduct(double* B_conduct, double* xyz_list, double* gauss_coord);
		void  GetB_advec(double* B_advec, double* xyz_list, double* gauss_coord);
		void  GetBprime_advec(double* Bprime_advec, double* xyz_list, double* gauss_coord);
		void  GetB_artdiff(double* B_artdiff, double* xyz_list, double* gauss_coord);
		void  CreateKMatrixMelting(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorThermal( Vec pg, void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorMelting( Vec pg, void* vinputs,int analysis_type,int sub_analysis_type);
		void  GetPhi(double* phi, double*  epsilon, double viscosity);
		double MassFlux(double* segment,double* ug);
		/*}}}*/


};
#endif  /* _PENTA_H */
