/*!\file Numpar.c
 * \brief: implementation of the Numpar object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./Numpar.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../DataSet/DataSet.h"
#include "../include/typedefs.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION Numpar::constructor {{{1*/
Numpar::Numpar(){
	return;
}
/*}}}*/
/*FUNCTION Numpar::creation {{{1*/
Numpar::Numpar(int numpar_id){
	id=numpar_id;

	meanvel=UNDEF;
	epsvel=UNDEF;
	artdiff=UNDEF;
	viscosity_overshoot=UNDEF;
	stokesreconditioning=UNDEF;
	control_type=NULL;
	cm_noisedmp=UNDEF;
	cm_mindmp_value=UNDEF;
	cm_mindmp_slope=UNDEF;
	cm_maxdmp_value=UNDEF;
	cm_maxdmp_slope=UNDEF;

	return;
}
/*}}}*/
/*FUNCTION Numpar::destructor {{{1*/
Numpar::~Numpar(){
	return;
}
/*}}}*/

/*Object marshall*/
/*FUNCTION Numpar::Marshall {{{1*/
void  Numpar::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Numpar: */
	enum_type=NumparEnum();
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall Numpar data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&meanvel,sizeof(meanvel));marshalled_dataset+=sizeof(meanvel);
	memcpy(marshalled_dataset,&epsvel,sizeof(epsvel));marshalled_dataset+=sizeof(epsvel);
	memcpy(marshalled_dataset,&artdiff,sizeof(artdiff));marshalled_dataset+=sizeof(artdiff);
	memcpy(marshalled_dataset,&viscosity_overshoot,sizeof(viscosity_overshoot));marshalled_dataset+=sizeof(viscosity_overshoot);
	memcpy(marshalled_dataset,&stokesreconditioning,sizeof(stokesreconditioning));marshalled_dataset+=sizeof(stokesreconditioning);
	memcpy(marshalled_dataset,&control_type,sizeof(control_type));marshalled_dataset+=sizeof(control_type);
	memcpy(marshalled_dataset,&cm_noisedmp,sizeof(cm_noisedmp));marshalled_dataset+=sizeof(cm_noisedmp);
	memcpy(marshalled_dataset,&cm_mindmp_value,sizeof(cm_mindmp_value));marshalled_dataset+=sizeof(cm_mindmp_value);
	memcpy(marshalled_dataset,&cm_mindmp_slope,sizeof(cm_mindmp_slope));marshalled_dataset+=sizeof(cm_mindmp_slope);
	memcpy(marshalled_dataset,&cm_maxdmp_value,sizeof(cm_maxdmp_value));marshalled_dataset+=sizeof(cm_maxdmp_value);
	memcpy(marshalled_dataset,&cm_maxdmp_slope,sizeof(cm_maxdmp_slope));marshalled_dataset+=sizeof(cm_maxdmp_slope);
	
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION Numpar::MarshallSize{{{1*/
int   Numpar::MarshallSize(){
	return sizeof(id)
		+sizeof(meanvel)
		+sizeof(epsvel)
		+sizeof(artdiff)
		+sizeof(viscosity_overshoot)
		+sizeof(stokesreconditioning)
		+sizeof(control_type)
		+sizeof(cm_noisedmp)
		+sizeof(cm_mindmp_value)
		+sizeof(cm_mindmp_slope)
		+sizeof(cm_maxdmp_value)
		+sizeof(cm_maxdmp_slope)
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION Numpar::Demarshall {{{1*/
void  Numpar::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&meanvel,marshalled_dataset,sizeof(meanvel));marshalled_dataset+=sizeof(meanvel);
	memcpy(&epsvel,marshalled_dataset,sizeof(epsvel));marshalled_dataset+=sizeof(epsvel);
	memcpy(&artdiff,marshalled_dataset,sizeof(artdiff));marshalled_dataset+=sizeof(artdiff);
	memcpy(&viscosity_overshoot,marshalled_dataset,sizeof(viscosity_overshoot));marshalled_dataset+=sizeof(viscosity_overshoot);
	memcpy(&stokesreconditioning,marshalled_dataset,sizeof(stokesreconditioning));marshalled_dataset+=sizeof(stokesreconditioning);
	memcpy(&control_type,marshalled_dataset,sizeof(control_type));marshalled_dataset+=sizeof(control_type);
	memcpy(&cm_noisedmp,marshalled_dataset,sizeof(cm_noisedmp));marshalled_dataset+=sizeof(cm_noisedmp);
	memcpy(&cm_mindmp_value,marshalled_dataset,sizeof(cm_mindmp_value));marshalled_dataset+=sizeof(cm_mindmp_value);
	memcpy(&cm_mindmp_slope,marshalled_dataset,sizeof(cm_mindmp_slope));marshalled_dataset+=sizeof(cm_mindmp_slope);
	memcpy(&cm_maxdmp_value,marshalled_dataset,sizeof(cm_maxdmp_value));marshalled_dataset+=sizeof(cm_maxdmp_value);
	memcpy(&cm_maxdmp_slope,marshalled_dataset,sizeof(cm_maxdmp_slope));marshalled_dataset+=sizeof(cm_maxdmp_slope);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/

/*Object functions*/
/*FUNCTION Numpar::Configure {{{1*/
void  Numpar::Configure(void* pparametersin){

	DataSet* parameters=NULL;

	/*Recover virtual pointer:*/
	parameters=(DataSet*)pparametersin;

	/*Go through parameters dataset, and find the Param object corresponding to our fields, 
	 * and update the fields: */
	parameters->FindParam(&meanvel,"meanvel");
	parameters->FindParam(&epsvel,"epsvel");
	if(!parameters->FindParam(&artdiff,"artdiff"))ISSMERROR(" error message: could not update artdiff field");
	if(!parameters->FindParam(&viscosity_overshoot,"viscosity_overshoot"))ISSMERROR(" error message: could not update viscosity_overshoot field");
	if(!parameters->FindParam(&stokesreconditioning,"stokesreconditioning"))ISSMERROR(" error message: could not update stokesreconditioning field");
	xfree((void**)&control_type); 
	parameters->FindParam(&control_type,"control_type");
	parameters->FindParam(&cm_noisedmp,"cm_noisedmp");
	parameters->FindParam(&cm_mindmp_value,"cm_mindmp_value");
	parameters->FindParam(&cm_mindmp_slope,"cm_mindmp_slope");
	parameters->FindParam(&cm_maxdmp_value,"cm_maxdmp_value");
	parameters->FindParam(&cm_maxdmp_slope,"cm_maxdmp_slope");

	return;
}
/*}}}*/
/*FUNCTION Numpar::copy {{{1*/
Object* Numpar::copy() {
	
	return new Numpar(*this); 

}
/*}}}*/
/*FUNCTION Numpar::DeepEcho {{{1*/
void Numpar::DeepEcho(void){

	printf("Numpar:\n");
	printf("   id: %i\n",id);
	printf("   meanvel: %g\n",meanvel);
	printf("   epsvel: %g\n",epsvel);
	printf("   artdiff: %i\n",artdiff);
	printf("   viscosity_overshoot: %g\n",viscosity_overshoot);
	printf("   stokesreconditioning: %g\n",stokesreconditioning);
	printf("   control_type: %s\n",control_type);
	printf("   cm_noisedmp: %g\n",cm_noisedmp);
	printf("   cm_mindmp_value: %g\n",cm_mindmp_value);
	printf("   cm_mindmp_slope: %g\n",cm_mindmp_slope);
	printf("   cm_maxdmp_value: %g\n",cm_maxdmp_value);
	printf("   cm_maxdmp_slope: %g\n",cm_maxdmp_slope);
}
/*}}}*/
/*FUNCTION Numpar::Echo{{{1*/
void Numpar::Echo(void){

	printf("Numpar:\n");
	printf("   id: %i\n",id);
	printf("   meanvel: %g\n",meanvel);
	printf("   epsvel: %g\n",epsvel);
	printf("   artdiff: %i\n",artdiff);
	printf("   viscosity_overshoot: %g\n",viscosity_overshoot);
	printf("   stokesreconditioning: %g\n",stokesreconditioning);
	printf("   control_type: %s\n",control_type);
	printf("   cm_noisedmp: %g\n",cm_noisedmp);
	printf("   cm_mindmp_value: %g\n",cm_mindmp_value);
	printf("   cm_mindmp_slope: %g\n",cm_mindmp_slope);
	printf("   cm_maxdmp_value: %g\n",cm_maxdmp_value);
	printf("   cm_maxdmp_slope: %g\n",cm_maxdmp_slope);
}
/*}}}*/
/*FUNCTION Numpar::Enum {{{1*/
int Numpar::Enum(void){

	return NumparEnum();

}
/*}}}*/
/*FUNCTION Numpar::GetId {{{1*/
int    Numpar::GetId(void){ return id; }
/*}}}*/
/*FUNCTION Numpar::GetName {{{1*/
char* Numpar::GetName(void){
	return "beam";
}
/*}}}*/
/*FUNCTION Numpar::MyRank {{{1*/
int    Numpar::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION Numpar::UpdateFromInputs {{{1*/
void  Numpar::UpdateFromInputs(void* vinputs){

	ParameterInputs* inputs=NULL;

	/*recover pointers: */
	inputs=(ParameterInputs*)vinputs;

	/*Update internal data if inputs holds new values: */
	inputs->Recover("meanvel",&meanvel);
	inputs->Recover("epsvel",&epsvel);
	inputs->Recover("artdiff",&artdiff);
	inputs->Recover("viscosity_overshoot",&viscosity_overshoot);
	inputs->Recover("stokesreconditioning",&stokesreconditioning);
	inputs->Recover("control_type",&control_type);
	inputs->Recover("cm_noisedmp",&cm_noisedmp);
	inputs->Recover("cm_mindmp_value",&cm_mindmp_value);
	inputs->Recover("cm_mindmp_slope",&cm_mindmp_slope);
	inputs->Recover("cm_maxdmp_value",&cm_maxdmp_value);
	inputs->Recover("cm_maxdmp_slope",&cm_maxdmp_slope);

}
/*}}}*/
