/*
 * CreateConstraintsBalancedvelocities.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"

void	CreateConstraintsBalancedvelocities(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i;
	int count=1;
	
	DataSet* constraints = NULL;
	Spc*    spc  = NULL;

	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*Fetch data: */
	IoModelFetchData(&iomodel->spcvelocity,NULL,NULL,iomodel_handle,"spcvelocity");

	count=1; //matlab indexing
	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){

			if ((int)iomodel->spcvelocity[6*i+0] && (int)iomodel->spcvelocity[6*i+1]){ //spc if vx and vy are constrained

				/*This grid needs to be spc'd: */
				constraints->AddObject(new Spc(count,i+1,1,pow( pow(*(iomodel->spcvelocity+6*i+4),2.0) + pow(*(iomodel->spcvelocity+6*i+5),2.0) ,0.5)));
				count++;
			}

		} //if((my_vertices[i]==1))
	}

	/*Free data: */
	xfree((void**)&iomodel->spcvelocity);
	
	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
