/*!\file: Sing.h
 * \brief prototypes for Sing element
 */ 

#ifndef _SING_H_
#define  _SING_H_

#include "./Element.h"
#include "./Node.h"
#include "./Matice.h"
#include "./Matpar.h"
#include "./ParameterInputs.h"
#include "./ElementProperties.h"
#include "../ModelProcessorx/IoModel.h"
#include "./Hook.h"

class Hook;
class ElementProperties;

class Sing: public Element{

	private: 

		/*ids:*/
		int id;

		Hook hnodes;  //hook to 2 nodes
		Hook hmatice; //hook to 1 matice
		Hook hmatpar; //hook to 1 matpar
		Hook hnumpar; //hook to 1 numpar

		ElementProperties properties;

	public:

		/*constructors, destructors: {{{1*/
		Sing();
		Sing(int sing_id,int* sing_node_ids, int sing_matice_id, int sing_matpar_id, int sing_numpar_id, ElementProperties* sing_properties);
		Sing(int sing_id,Hook* sing_hnodes, Hook* sing_hmatice, Hook* sing_hmatpar, Hook* sing_hnumpar, ElementProperties* sing_properties);
		Sing(int i, IoModel* iomodel);
		~Sing();
		/*}}}*/
		/*object management: {{{1*/
		void  Configure(void* loads,void* nodes,void* materials,void* parameters);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   GetId(); 
		char* GetName();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  SetClone(int* minranks);
		int   MyRank();
		/*}}}*/
		/*numerics: {{{1*/
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  UpdateFromInputs(void* inputs);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void  CreateKMatrixDiagnosticHutter(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  GetParameterValue(double* pp, double* plist, double* gauss_l1l2l3);
		void  CreatePVectorDiagnosticHutter(Vec pg,void* inputs,int analysis_type,int sub_analysis_type);
		void* GetMatPar();
		void  NodeConfiguration(int sing_node_id,Node* sing_node,int sing_node_offset);
		void  MaticeConfiguration(Matice* matice,int matice_offset);
		void  MatparConfiguration(Matpar* matpar,int matpar_offset);
		void  ComputePressure(Vec p_g);
		void  GetNodes(void** vpnodes);
		/*}}}*/
		/*not implemented: {{{1*/
		int   GetShelf();
		int   GetOnBed();
		void  GetBedList(double*);
		void  GetThicknessList(double* thickness_list);
		void  Du(_p_Vec*,void*,int,int);
		void  Gradj(_p_Vec*, void*, int, int,char*);
		void  GradjDrag(_p_Vec*, void*, int,int);
		void  GradjB(_p_Vec*, void*, int,int);
		double Misfit(void*,int,int);
		double SurfaceArea(void*,int,int);
		double CostFunction(void*,int,int);
		double MassFlux(double* segment,double* ug);
		/*}}}*/



};
#endif //ifndef _SING_H_

