/*!\file FemModel.c
 * \brief: implementation of the FemModel object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "../shared/shared.h"
#include "../include/macros.h"
#include "./FemModel.h"

/*Object constructors, destructors: {{{1:*/
FemModel::FemModel(){

	elements=NULL;
	nodes=NULL;
	vertices=NULL;
	constraints=NULL;
	loads=NULL;
	materials=NULL;
	parameters=NULL;

	partition=NULL;
	tpartition=NULL;
	yg=NULL;
	Rmg=NULL;
	nodesets=NULL;
	ys=NULL;
	ys0=NULL;
	Gmn=NULL;

}

FemModel::FemModel(DataSet* femmodel_elements,DataSet* femmodel_nodes,DataSet* femmodel_vertices, DataSet* femmodel_constraints,DataSet* femmodel_loads,
		DataSet* femmodel_materials,DataSet* femmodel_parameters, DofVec* femmodel_partition,DofVec* femmodel_tpartition,DofVec* femmodel_yg,
		Mat femmodel_Rmg,Mat femmodel_Gmn,NodeSets* femmodel_nodesets,Vec femmodel_ys,Vec femmodel_ys0){


	elements=femmodel_elements;
	nodes=femmodel_nodes;
	vertices=femmodel_vertices;
	constraints=femmodel_constraints;
	loads=femmodel_loads;
	materials=femmodel_materials;
	parameters=femmodel_parameters;

	partition=femmodel_partition;
	tpartition=femmodel_tpartition;
	yg=femmodel_yg;
	Rmg=femmodel_Rmg;
	nodesets=femmodel_nodesets;
	ys=femmodel_ys;
	ys0=femmodel_ys0;
	Gmn=femmodel_Gmn;

}

FemModel::~FemModel(){

	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete constraints;
	delete materials;
	delete parameters;

	delete partition;
	delete tpartition;
	delete yg;
	MatFree(&Rmg);
	delete nodesets;
	VecFree(&ys);
	VecFree(&ys0);
	MatFree(&Gmn);

}
/*}}}*/
/* Object management: {{{1*/
void FemModel::Echo(void){

	printf("FemModels echo: \n");
	printf("   elements: %p\n",elements);
	printf("   nodes: %p\n",nodes);
	printf("   vertices: %p\n",vertices);
	printf("   loads: %p\n",loads);
	printf("   materials: %p\n",materials);
	printf("   parameters: %p\n",parameters);
	
	printf("   partition: %p\n",partition);
	printf("   tpartition: %p\n",tpartition);
	printf("   yg: %p\n",yg);
	printf("   Rmg: %p\n",Rmg);
	printf("   nodesets: %p\n",nodesets);
	printf("   ys: %p\n",ys);
	printf("   ys0: %p\n",ys0);
	printf("   Gmn: %p\n",Gmn);

}

void FemModel::DeepEcho(void){
	
	printf("FemModels echo: \n");
	printf("   elements: \n");
	elements->Echo();
	printf("   nodes: \n");
	nodes->Echo();
	printf("   vertices: \n");
	vertices->Echo();
	printf("   loads: \n");
	nodes->Echo();
	printf("   materials: \n");
	nodes->Echo();
	printf("   parameters: \n");
	nodes->Echo();
	
	printf("   partition: \n");
	partition->Echo();
	printf("   tpartition: \n");
	tpartition->Echo();
	printf("   yg: \n");
	yg->Echo();
	printf("   Rmg: \n");
	MatView(Rmg,PETSC_VIEWER_STDOUT_WORLD);
	printf("   nodesets: \n");
	nodesets->Echo();
	printf("   ys: \n");
	VecView(ys,PETSC_VIEWER_STDOUT_WORLD);
	printf("   ys0: \n");
	VecView(ys0,PETSC_VIEWER_STDOUT_WORLD);
	printf("   Gmn: \n");
	MatView(Gmn,PETSC_VIEWER_STDOUT_WORLD);

}
int   FemModel::GetId(void){
	ISSMERROR("not implemented yet!");
}

int   FemModel::MyRank(void){
	ISSMERROR("not implemented yet!");
}

void  FemModel::Marshall(char** pmarshalled_dataset){
	ISSMERROR("not implemented yet!");
}

int   FemModel::MarshallSize(void){
	ISSMERROR("not implemented yet!");
}
char*   FemModel::GetName(void){
	ISSMERROR("not implemented yet!");
}
void  FemModel::Demarshall(char** pmarshalled_dataset){
	ISSMERROR("not implemented yet!");
}
int   FemModel::Enum(void){
	ISSMERROR("not implemented yet!");
}
Object* FemModel::copy(void){
	ISSMERROR("not implemented yet!");
}


int FemModel::FindParam(double* pscalar,char* name){
	
	return parameters->FindParam(pscalar,name);

}
int FemModel::FindParam(int* pinteger,char* name){
	
	return parameters->FindParam(pinteger,name);

}

int FemModel::FindParam(char** pstring,char* name){
	
	return parameters->FindParam(pstring,name);

}

int FemModel::FindParam(char*** pstringarray,int* pM,char* name){
	
	return parameters->FindParam(pstringarray,pM,name);

}

int FemModel::FindParam(double** pdoublearray,int* pM,int* pN,char* name){
	
	return parameters->FindParam(pdoublearray,pM,pN,name);

}

int FemModel::FindParam(Vec* pvec,char* name){
	
	return parameters->FindParam(pvec,name);

}

int FemModel::FindParam(Mat* pmat,char* name){
	
	return parameters->FindParam(pmat,name);

}


/*access to internal data: */
DataSet*            FemModel::get_elements(void){return elements;}
DataSet*            FemModel::get_nodes(void){return nodes ;}
DataSet*            FemModel::get_vertices(void){return vertices ;}
DataSet*            FemModel::get_constraints(void){return constraints ;}
DataSet*            FemModel::get_loads(void){return loads;}
DataSet*            FemModel::get_materials(void){return materials;}
DataSet*            FemModel::get_parameters(void){return parameters;}
DofVec*                 FemModel::get_partition(void){return partition;}
DofVec*                 FemModel::get_tpartition(void){return tpartition;}
DofVec*                 FemModel::get_yg(void){return yg;}
Mat                 FemModel::get_Rmg(void){return Rmg;}
NodeSets*           FemModel::get_nodesets(void){return nodesets;}
Vec                 FemModel::get_ys(void){return ys;}
Vec                 FemModel::get_ys0(void){return ys0;}
Mat                 FemModel::get_Gmn(void){return Gmn;}
/*}}}*/
/*FUNCTION FemModel::FemModel {{{1*/
void  FemModel::SetClone(int* minranks){

	ISSMERROR("not implemented yet");
}
/*}}}1*/
