/*!\file Penpair.h
 * \brief: header file for penpair object */

#ifndef _PENPAIR_H_
#define _PENPAIR_H_

#include "./Load.h"
#include "./Node.h"
#include "./Element.h"

class Element;
class Penpair: public Load{

	private: 

		int		id;
		double  penalty_offset; //penalty used
		int     penalty_lock;  //maximum counter can go until locks the penalty.
		
		/*nodes: */
		int     node_ids[2];
		Node*   nodes[2];
		int     node_offsets[2];

		/*penalty pairing of one dof: */
		int     dof;

	public:

		Penpair();
		Penpair(int	id, double penalty_offset,int  penalty_lock,int nodes_ids[2],int dof);
		~Penpair();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  Configure(void* elements,void* nodes,void* materials);
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  UpdateFromInputs(void* inputs);
		void  PenaltyCreateKMatrix(Mat Kgg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		Object* copy();
		void   SetClone(int* minranks);

};

#endif  /* _PENPAIR_H_ */


