/*
 * CreateConstraintsPrognostic.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"

void	CreateConstraintsPrognostic(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i;
	int count=0;
	
	DataSet* constraints = NULL;
	Spc*    spc  = NULL;

	/*spc intermediary data: */
	double* spcthickness=NULL;
	
	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*Fetch data: */
	IoModelFetchData(&spcthickness,NULL,NULL,iomodel_handle,"spcthickness");

	count=1;//matlab indexing
	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){

			if ((int)spcthickness[2*i]){

				constraints->AddObject(new Spc(count,i+1,1,*(spcthickness+2*i+1)));
				count++;
			}

		} //if((my_vertices[i]==1))
	}

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	/*Free data: */
	xfree((void**)&spcthickness);
	
	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
