/*!\file UpdateVertexPositionsx
 * \brief update vertex positions using new geometry defined by new thickness and new bed.
 */

#include "./UpdateVertexPositionsx.h"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void UpdateVertexPositionsx( DataSet* vertices, Vec thickness,Vec bed){

	/*intermediary: */
	double* thickness_serial=NULL;
	double* bed_serial=NULL;

	/*serialize inputs: */
	VecToMPISerial(&thickness_serial,thickness);
	VecToMPISerial(&bed_serial,bed);
	
	/*Update elements, nodes, loads and materials from new geometry: */
	vertices->UpdateVertexPositions(thickness_serial,bed_serial);

	/*Free ressources:*/
	xfree((void**)&thickness_serial);
	xfree((void**)&bed_serial);
}
