/*!\file FieldAverageOntoVerticesx
 * \brief: average field throfieldh thickness
 */

#include "./FieldAverageOntoVerticesx.h"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void FieldAverageOntoVerticesx( Vec field, DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, DataSet* parameters,char* fieldname){

	double* field_serial=NULL;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Serialize field: */
	VecToMPISerial(&field_serial,field);

	/*Depth average field, onto base of mesh: */
	nodes->FieldAverageOntoVertices(field,field_serial,fieldname);

	/*Assemble vector: */
	VecAssemblyBegin(field);
	VecAssemblyEnd(field);

	/*Free ressources:*/
	xfree((void**)&field_serial);

}
