/*
 * CreateConstraintsBalancedvelocities.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"


void	CreateConstraintsBalancedvelocities(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){


	int i;
	int count;
	
	DataSet* constraints = NULL;
	Spc*    spc  = NULL;

	/*spc intermediary data: */
	int spc_sid;
	int spc_node;
	int spc_dof;
	double spc_value;
	
	double* spcvelocity=NULL;
	
	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*Fetch data: */
	IoModelFetchData(&spcvelocity,NULL,NULL,iomodel_handle,"spcvelocity");

	count=0;

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if((iomodel->my_vertices[i]==1)){
	#endif

		if ((int)spcvelocity[6*i+0] && (int)spcvelocity[6*i+1]){ //spc if vx and vy are constrained
	
			/*This grid needs to be spc'd: */
			spc_sid=count;
			spc_node=i+1;
			spc_dof=1; //we enforce first translation degree of freedom, for temperature
			spc_value=pow( pow(*(spcvelocity+6*i+4),2.0) + pow(*(spcvelocity+6*i+5),2.0) ,0.5);

			spc = new Spc(spc_sid,spc_node,spc_dof,spc_value);
			constraints->AddObject(spc);
			count++;
		}

	#ifdef _PARALLEL_
	} //if((my_vertices[i]==1))
	#endif
	}

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	/*Free data: */
	xfree((void**)&spcvelocity);
	
	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
