/*!\file:  OutputResults.cpp
 * \brief: go through results dataset, and for each result, write it to disk.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "../DataSet/DataSet.h"
#include "../io/io.h"
#include "../objects/objects.h"

void OutputResults(DataSet* results,char* filename){

	int i;
	Result* result=NULL;
	FILE* fid=NULL;
	extern int my_rank;

	/* Open output file to write raw binary data: */
	if(my_rank==0){
		fid=pfopen(filename,"wb");

		for(i=0;i<results->Size();i++){
			result=(Result*)results->GetObjectByOffset(i);

			/*write result to disk: */
			result->WriteData(fid);
		}
		
		/*Close file: */
		pfclose(fid,filename);
	}
}
