/*!\file UpdateFromInputsx
 * \brief: update datasets using  parameter inputs
 */

#include "./UpdateFromInputsx.h"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

int UpdateFromInputsx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, DataSet* parameters,ParameterInputs* inputs) {

	int noerr=1;
	int i;

	int  found=0;
	extern int num_procs;
	extern int my_rank;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Update elements, nodes, loads and materials from inputs: */
	elements->UpdateFromInputs(inputs);
	nodes->UpdateFromInputs(inputs);
	loads->UpdateFromInputs(inputs);
	materials->UpdateFromInputs(inputs);

	return noerr;

}
