/*\file Gradj.c
 *\brief: compute gradients for inverse control method
 */

#include "./Gradj.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* vertices=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	DataSet* parameters=NULL;
	char*    control_type=NULL;
	ParameterInputs* inputs=NULL;
	int      analysis_type;
	int      sub_analysis_type;
	int      numberofnodes;

	/* output datasets: */
	Vec grad_g=NULL;


	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&GradjUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	parameters->FindParam(&numberofnodes,"numberofnodes");
	parameters->FindParam(&control_type,"control_type");
	FetchData(&analysis_type,ANALYSIS);
	FetchData(&sub_analysis_type,SUBANALYSIS);

	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);

	/*!Call core code: */
	Gradjx(&grad_g,numberofnodes,elements,nodes,vertices,loads,materials,parameters,inputs,analysis_type,sub_analysis_type,control_type);

	/*write output : */
	WriteData(GRADG,grad_g);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	xfree((void**)&control_type);
	delete inputs;
	VecFree(&grad_g);

	/*end module: */
	MODULEEND();
}

void GradjUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [grad_g] = %s(elements, nodes,loads, materials, parameters,inputs);\n",__FUNCT__);
	_printf_("\n");
}
