/*\file UpdateVertexPositions.c
 *\brief: update vertex positions using new geometry defined by new bed and new thickness
 */

#include "./UpdateVertexPositions.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* vertices=NULL;
	Vec      thickness=NULL;
	Vec      bed=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateVertexPositionsUsage);

	/*Input datasets: */
	FetchData(&vertices,VERTICES);
	FetchData(&thickness,THICKNESS);
	FetchData(&bed,BED);
	
	/*!Generate internal degree of freedom numbers: */
	UpdateVertexPositionsx(vertices,thickness,bed);

	/*write output datasets: */
	WriteData(VERTICESOUT,vertices);

	/*Free ressources: */
	delete vertices;
	VecFree(&thickness);
	VecFree(&bed);

	/*end module: */
	MODULEEND();
}

void UpdateVertexPositionsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [vertices] = %s(vertices, thickness, bed);\n",__FUNCT__);
	_printf_("\n");
}
