/*
 * CreateConstraintsDiagnosticHoriz.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"

void	CreateConstraintsDiagnosticVert(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i;
	DataSet* constraints = NULL;

	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*return if 2d mesh*/
	if (strcmp(iomodel->meshtype,"2d")==0)goto cleanup_and_return;

	/*Fetch data: */
	IoModelFetchData(&iomodel->spcvelocity,NULL,NULL,iomodel_handle,"spcvelocity");

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){

		/*keep only this partition's nodes:*/
		if(iomodel->my_vertices[i]){

			if ((int)spcvelocity[6*i+2]){
				constraints->AddObject(new Spc(count,i+1,1,*(iomodel->spcvelocity+6*i+5)/iomodel->yts)); //add count'th spc, on node i+1, setting dof 1 to vx.

			}
		} //if((my_grids[i]==1))
	}

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	/*Free data: */
	xfree((void**)&iomodel->spcvelocity);
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
