/*
 * CreateConstraintsBalancedthickness.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"


void	CreateConstraintsBalancedthickness(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){


	int i;
	int count=0;
	DataSet* constraints = NULL;

	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*Fetch data: */
	IoModelFetchData(&iomodel->spcthickness,NULL,NULL,iomodel_handle,"spcthickness");

	count=1;
	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		if(iomodel->my_vertices[i]){
			
			if ((int)iomodel->spcthickness[2*i]){
		
				constraints->AddObject(new Spc(count,i+1,1,*(iomodel->spcthickness+2*i+1)));//we enforce first translation degree of freedom, for temperature
				count++;
			}
		}
	}

	/*Free data: */
	xfree((void**)&iomodel->spcthickness);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
