/*!\file Node.h
 * \brief: header file for node object
 */

#ifndef _NODE_H_
#define _NODE_H_


/*indefinitions: */
class Object;
class Vertex;
struct IoModel;
class Hook;
class DofIndexing;
class NodeProperties;
class Node;

#include "./Object.h"
#include "../DataSet/DataSet.h"
#include "./Hook.h"
#include "./Vertex.h"
#include "./DofIndexing.h"
#include "./NodeProperties.h"
#include "../toolkits/toolkits.h"
#include "../ModelProcessorx/IoModel.h"

class Node: public Object{

	private: 

		int	    id; 
				
		DofIndexing    indexing;
		NodeProperties properties;
		Hook           hvertex;
		Hook           hupper_node;

		
	public:

		/*FUNCTION constructors, destructors {{{1*/
		Node();
		Node(int id,int vertex_id, int upper_node_id, int partitionborder,int numberofdofs, NodeProperties* node_properties);
		Node(int id,DofIndexing* indexing, NodeProperties* properties, Hook* vertex, Hook* upper_node);
		Node(int i, IoModel* iomodel);
		Node(int i,int j,IoModel* iomodel);
		~Node();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		void  Configure(void* pnodes, void* pvertices);
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   GetId(void); 
		char* GetName();
		int   GetVertexDof(void);
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank(void);
		void  SetVertexDof(int in_dof);
		/*}}}*/
		/*FUNCTION numerical routines {{{1*/
		void  DistributeDofs(int* pdofcount,int* pdofcount1);
		void  UpdateDofs(int dofcount,int dofcount1);
		void  ShowBorderDofs(int* borderdofs,int* borderdofs1);
		void  UpdateBorderDofs(int* allborderdofs,int* allborderdofs1);
		void  CreatePartition(Vec partition);
		void  SetClone(int* minranks);
		int   GetNumberOfDofs();
		int   IsClone();
		void  ApplyConstraint(Vec yg,int dof,double value);
		void  DofInSSet(int dof);
		void  DofInMSet(int dof);
		 int  DofIsInMSet(int dof);
		int   GetDof(int dofindex);
		void  CreateVecSets(Vec pv_g,Vec pv_m,Vec pv_n,Vec pv_f,Vec pv_s);
		void  GetDofList(int* outdoflist,int* pnumberofdofspernode);
		int   GetDofList1(void);
		double GetX();
		double GetY();
		double GetZ();
		double GetSigma();
		Object* copy();
		void  UpdateFromInputs(void* inputs);
		Node* GetUpperNode();
		int   IsOnBed();
		int   IsOnSurface();
		void  FreezeDof(int dof);
		void  FieldAverageOntoVertices(Vec field,double* field_serial,char* fieldname);
		void  FieldDepthAverageAtBase(Vec field,double* field_serial,char* fieldname);
		int   IsOnShelf();
		int   IsOnSheet();
		void  FieldExtrude(Vec field,double* field_serial,char* field_name);
		void  UpdateNodePosition(double* thickness,double* bed);
		/*}}}*/
};

#endif  /* _NODE_H_ */
