/*! \file CreateLoadsDiagnosticStokes.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../IoModel.h"


void	CreateLoadsDiagnosticStokes(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){


	DataSet*    loads    = NULL;
	Icefront*   icefront = NULL;
	Pengrid*    pengrid  = NULL;

	int segment_width;
	int element;

	/*pengrid intermediary data: */
	int pengrid_id;
	int pengrid_mparid;
	int pengrid_node_id;
	int pengrid_dof;
	double pengrid_penalty_offset;
	int pengrid_active=0;
	int pengrid_thermal_steadystate=1;
	int pengrid_stabilize_constraints=0;

	int numberofpressureloads;
	int count;


	/*Create loads: */
	loads   = new DataSet(LoadsEnum());

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!iomodel->isstokes)goto cleanup_and_return;

	/*Create pressure loads as boundary conditions. Pay attention to the partitioning if we are running in parallel (the grids
	 * referenced by a certain load must belong to the cluster node): */
	IoModelFetchData(&iomodel->pressureload,&numberofpressureloads,NULL,iomodel_handle,"pressureload");
	IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");

	count=0;

	/*First load data:*/
	for (i=0;i<numberofpressureloads;i++){
		
		segment_width=6;

		element=(int)(*(iomodel->pressureload+segment_width*i+segment_width-2)-1); //element is in the penultimate column (grid1 grid2 ... elem fill)

		/*Now, if this element is not in the partition, pass: */
		if(!iomodel->my_elements[i])continue;
	
		/*Do not create ice front if it is not a Stokes element*/
		if (!(int)*(iomodel->elements_type+2*element+1)==StokesFormulationEnum()){ 
			continue;
		}

		/*Create and  add load: */
		loads->AddObject(new Icefront(i,iomodel));

	}
	/*Free data: */
	xfree((void**)&iomodel->pressureload);
	xfree((void**)&iomodel->elements_type);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);

	//create penalties for grids on the base of icesheet. We must have wb=ub*db/dx+vb*db/dy

	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridonstokes,NULL,NULL,iomodel_handle,"gridonstokes");
	
	for (i=0;i<iomodel->numberofvertices;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if((iomodel->my_grids[i]==1)){
	#endif

		if ((iomodel->gridonbed[i]) && (iomodel->gridonicesheet[i]) && (iomodel->gridonstokes[i])){

			pengrid_id=count+1; //matlab indexing
			pengrid_node_id=i+1;
			pengrid_dof=1;
			pengrid_penalty_offset=iomodel->penalty_offset;
			pengrid_mparid=iomodel->numberofelements+1;//refers to the corresponding parmat property card
			pengrid_stabilize_constraints=iomodel->stabilize_constraints;
			pengrid= new Pengrid(pengrid_id, pengrid_node_id,pengrid_mparid,pengrid_dof, pengrid_active, pengrid_penalty_offset,pengrid_thermal_steadystate,pengrid_stabilize_constraints);
			
			loads->AddObject(pengrid);
			count++;
		}
	#ifdef _PARALLEL_
	} //if((iomodel->my_grids[i]==1))
	#endif
	}

	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonstokes);
	xfree((void**)&iomodel->gridonicesheet);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*ploads=loads;

}
