/*!\file: CreateParametersBalancedthickness.cpp
 * \brief driver for creating parameters dataset, for prognostic analysis.
 */ 

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"

void CreateParametersBalancedthickness(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int      i;
	int      dim;

	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	double* u_g=NULL;
	double* pressure=NULL;
	double* temperature=NULL;
	double* thickness=NULL;
	double* surface=NULL;
	double* bed=NULL;
	double* accumulation=NULL;
	double* melting=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Get vx and vy: */
	IoModelFetchData(&vx,NULL,NULL,iomodel_handle,"vx");
	IoModelFetchData(&vy,NULL,NULL,iomodel_handle,"vy");
	IoModelFetchData(&vz,NULL,NULL,iomodel_handle,"vz");

	u_g=(double*)xcalloc(iomodel->numberofvertices*3,sizeof(double));

	if(vx) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+0]=vx[i]/iomodel->yts;
	if(vy) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+1]=vy[i]/iomodel->yts;
	if(vz) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+2]=vz[i]/iomodel->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(u_g,3*iomodel->numberofvertices,3);
	parameters->AddObject(param);


	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);
	xfree((void**)&u_g);

	/*Get melting: */
	IoModelFetchData(&melting,NULL,NULL,iomodel_handle,"melting");
	if(melting) for(i=0;i<iomodel->numberofvertices;i++)melting[i]=melting[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"m_g",DOUBLEVEC);
	if(melting) param->SetDoubleVec(melting,iomodel->numberofvertices,1);
	else param->SetDoubleVec(melting,0,1);
	parameters->AddObject(param);

	/*Free melting: */
	xfree((void**)&melting);

	/*Get accumulation: */
	IoModelFetchData(&accumulation,NULL,NULL,iomodel_handle,"accumulation");
	if(accumulation) for(i=0;i<iomodel->numberofvertices;i++)accumulation[i]=accumulation[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"a_g",DOUBLEVEC);
	if(accumulation) param->SetDoubleVec(accumulation,iomodel->numberofvertices,1);
	else param->SetDoubleVec(accumulation,0,0);
	parameters->AddObject(param);

	/*Free accumulation: */
	xfree((void**)&accumulation);

	/*Assign output pointer: */
	*pparameters=parameters;
}
