/*!\file Riftfront.h
 * \brief: header file for riftfront object
 */

#ifndef _RIFTFRONT_H_
#define _RIFTFRONT_H_

#include "./Load.h"
#include "./Matpar.h"
#include "./Element.h"
#include "./Node.h"
#include "./ParameterInputs.h"

#define MAX_RIFTFRONT_GRIDS 2 //max number of grids on a rift flank, only 2 because 2d for now.
#define RIFTFRONTSTRING 20 //max string length

class Element;
class Riftfront: public Load {

	private: 
		char	type[RIFTFRONTSTRING];
		int		id;

		/*nodes: */
		int   node_ids[MAX_RIFTFRONT_GRIDS]; //node ids
		Node* nodes[MAX_RIFTFRONT_GRIDS]; //node pointers
		int   node_offsets[MAX_RIFTFRONT_GRIDS]; //node offsets in nodes dataset

		/*material: */
		int mparid;
		Matpar* matpar; 
		int   matpar_offset;

		/*properties: */
		double		h[MAX_RIFTFRONT_GRIDS]; //thickness
		double		b[MAX_RIFTFRONT_GRIDS]; //bed
		double		s[MAX_RIFTFRONT_GRIDS]; //surface

		double      normal[2];
		double      length;
		int         fill;
		double      friction;
		double      fraction;
		double      fractionincrement;
		bool        shelf;

		double      penalty_offset;
		int         penalty_lock;

		/*computational: */
		bool        active;
		bool        frozen;
		int         counter;
		bool        prestable;
		bool        material_converged;


	public:

		/*constructors,destructors: {{{1*/
		Riftfront();
		void Init(char type[RIFTFRONTSTRING],int id, int node_ids[MAX_RIFTFRONT_GRIDS], int mparid, double h[MAX_RIFTFRONT_GRIDS],double b[MAX_RIFTFRONT_GRIDS],double s[MAX_RIFTFRONT_GRIDS],double normal[2],double length,int fill,double friction, double fraction, double fractionincrement, double penalty_offset, int penalty_lock,bool active,bool frozen, int counter,bool prestable,bool shelf);
		Riftfront(char type[RIFTFRONTSTRING],int id, int node_ids[MAX_RIFTFRONT_GRIDS], int mparid, double h[MAX_RIFTFRONT_GRIDS],double b[MAX_RIFTFRONT_GRIDS],double s[MAX_RIFTFRONT_GRIDS],double normal[2],double length,int fill,double friction, double fraction, double fractionincrement, double penalty_offset, int penalty_lock,bool active,bool frozen, int counter,bool prestable,bool shelf);
		~Riftfront();
		/*}}}*/
		/*object management: {{{1*/
		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  Configure(void* elements,void* nodes,void* materials);
		Object* copy();
		/*}}}*/
		/*numerics: {{{1*/
		void  UpdateFromInputs(void* inputs);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrix(Mat Kgg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		bool  PreStable();
		void  SetPreStable();
		int   PreConstrain(int* punstable, void* inputs, int analysis_type);
		int   Constrain(int* punstable, void* inputs, int analysis_type);
		void  FreezeConstraints(void* inputs, int analysis_type);
		bool  IsFrozen(void);
		int   Penetration(double* ppenetration, void* inputs, int analysis_type);
		int   MaxPenetration(double* ppenetration, void* inputs, int analysis_type);
		int   PotentialUnstableConstraint(int* punstable, void* inputs, int analysis_type);
		int   IsMaterialStable(void* inputs, int analysis_type);
		void  OutputProperties(Vec riftproperties);
		/*}}}*/
};

#endif  /* _RIFTFRONT_H_ */
