/*
 * CreateConstraintsDiagnosticHoriz.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"


void	CreateConstraintsDiagnosticHoriz(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){


	int i,j;
	int count=0;
	
	DataSet* constraints = NULL;
	Spc*    spc  = NULL;
	Rgb*    rgb  = NULL;
	int     node1,node2;

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn)goto cleanup_and_return;
	
	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*Spcs: fetch data: */
	IoModelFetchData(&iomodel->spcvelocity,NULL,NULL,iomodel_handle,"spcvelocity");
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");

	count=1; //matlab indexing
	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		if(iomodel->my_vertices[i]){

			if ((int)iomodel->spcvelocity[6*i+0] | (int)iomodel->gridonhutter[i]) 
				constraints->AddObject(new Spc(count,i+1,1,*(iomodel->spcvelocity+6*i+3)/iomodel->yts)); //add count'th spc, on node i+1, setting dof 1 to vx.

			count++;
			
			if ((int)iomodel->spcvelocity[6*i+1] | (int)iomodel->gridonhutter[i]) 
				constraints->AddObject(new Spc(count,i+1,2,*(iomodel->spcvelocity+6*i+4)/iomodel->yts)); //add count'th spc, on node i+1, setting dof 2 to vy

			count++;
		}
	}
	  
	/*Free data: */
	xfree((void**)&iomodel->spcvelocity);
	xfree((void**)&iomodel->gridonhutter);

	
	/*penalty loads: */
	IoModelFetchData(&iomodel->penalties,&iomodel->numpenalties,NULL,iomodel_handle,"penalties");
	
	count=1; //matlab indexing
	if(iomodel->numpenalties){

		for (i=0;i<iomodel->numpenalties;i++){

			for(j=1;j<iomodel->numlayers;j++){
	
				/*We are pairing nodes along a vertical profile.*/
				node1=(int)*(iomodel->penalties+iomodel->numlayers*i);
				node2=(int)*(iomodel->penalties+iomodel->numlayers*i+j);

				constraints->AddObject(new Rgb(count,node1,node2,1));  //add count'th Rgb on dof 1 between node1 and node2
				
				count++;
				
				constraints->AddObject(new Rgb(count,node1,node2,2));  //add count'th Rgb on dof 1 between node1 and node2

			}
		}
	}

	/*Free data: */
	xfree((void**)&iomodel->penalties);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();
	
	cleanup_and_return:
	/*Assign output pointer: */
	*pconstraints=constraints;
}
