/*
 * CreateElementsNodesAndMaterialsDiagnosticVert.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../include/typedefs.h"
#include "../IoModel.h"

void	CreateElementsNodesAndMaterialsDiagnosticVert(DataSet** pelements,DataSet** pnodes, DataSet** pvertices,DataSet** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i,j,k,n;

	/*DataSets: */
	DataSet*    elements  = NULL;
	DataSet*    nodes = NULL;
	DataSet*    vertices = NULL;
	DataSet*    materials = NULL;
	
	/*Objects: */
	Node*       node   = NULL;
	Vertex*     vertex = NULL;
	Penta*      penta = NULL;
	Matice*     matice  = NULL;
	Matpar*     matpar  = NULL;

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (strcmp(iomodel->meshtype,"2d")==0)goto cleanup_and_return;

	/*First create the elements, nodes and material properties: */
	elements  = new DataSet(ElementsEnum());
	nodes     = new DataSet(NodesEnum());
	vertices  = new DataSet(VerticesEnum());
	materials = new DataSet(MaterialsEnum());

	/*Partition elements and vertices and nodes: */
	Partitioning(&iomodel->my_elements, &iomodel->my_vertices, &iomodel->my_nodes, &iomodel->my_bordervertices, iomodel, iomodel_handle);

	/*Create 3d elements: */
	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->elementoniceshelf,NULL,NULL,iomodel_handle,"elementoniceshelf");
	IoModelFetchData(&iomodel->elementonbed,NULL,NULL,iomodel_handle,"elementonbed");
	IoModelFetchData(&iomodel->elementonsurface,NULL,NULL,iomodel_handle,"elementonsurface");
	IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
	IoModelFetchData(&iomodel->melting,NULL,NULL,iomodel_handle,"melting");
	IoModelFetchData(&iomodel->accumulation,NULL,NULL,iomodel_handle,"accumulation");
	IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,"elementonwater");
	
	for (i=0;i<iomodel->numberofelements;i++){

		if(iomodel->my_elements[i]){

			/*Create and add penta element to elements dataset: */
			elements->AddObject(new Penta(i,iomodel));

			/*Create and add material property to materials dataset: */
			materials->AddObject(new Matice(i,iomodel,6));

		}

	}//for (i=0;i<numberofelements;i++)

	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->elementoniceshelf);
	xfree((void**)&iomodel->elementonbed);
	xfree((void**)&iomodel->elementonsurface);
	xfree((void**)&iomodel->elements_type);
	xfree((void**)&iomodel->melting);
	xfree((void**)&iomodel->accumulation);
	xfree((void**)&iomodel->elementonwater);

	/*Add new constrant material property to materials, at the end: */
	materials->AddObject(new Matpar(iomodel));
	
	/*First fetch data: */
	IoModelFetchData(&iomodel->deadgrids,NULL,NULL,iomodel_handle,"deadgrids");
	IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
	IoModelFetchData(&iomodel->x,NULL,NULL,iomodel_handle,"x");
	IoModelFetchData(&iomodel->y,NULL,NULL,iomodel_handle,"y");
	IoModelFetchData(&iomodel->z,NULL,NULL,iomodel_handle,"z");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");

	for (i=0;i<iomodel->numberofvertices;i++){

		/*vertices and nodes (same number, as we are running continuous galerkin formulation: */
		if(iomodel->my_vertices[i]){

			/*Add vertex to vertices dataset: */
			vertices->AddObject(new Vertex(i,iomodel));

			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(i,iomodel));

		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->deadgrids);
	xfree((void**)&iomodel->x);
	xfree((void**)&iomodel->y);
	xfree((void**)&iomodel->z);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->uppernodes);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->gridoniceshelf);
	
	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	elements->Presort();
	nodes->Presort();
	vertices->Presort();
	materials->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*pelements=elements;
	*pnodes=nodes;
	*pvertices=vertices;
	*pmaterials=materials;

}
