/*! \file Tria.h 
 *  \brief: header file for tria object
 */

#ifndef _TRIA_H_
#define _TRIA_H_

class Object;
class Element;
class Hook;
class ElementProperties;
class DataSet;
class Node;
struct IoModel;

#include "./Object.h"
#include "./Element.h"
#include "./Hook.h"
#include "./Node.h"
#include "./ElementProperties.h"
#include "../ModelProcessorx/IoModel.h"
#include "../DataSet/DataSet.h"

class Tria: public Element{

	private: 

		int  id;

		Hook hnodes;  //hook to 3 nodes
		Hook hmatice; //hook to 1 matice
		Hook hmatpar; //hook to 1 matpar
		Hook hnumpar; //hook to 1 numpar

		ElementProperties properties;
	
	public:

		/*FUNCTION constructors, destructors {{{1*/
		Tria();
		Tria(int tria_id,int* tria_node_ids, int tria_matice_id, int tria_matpar_id, int tria_numpar_id, ElementProperties* tria_properties);
		Tria(int tria_id,Hook* tria_hnodes, Hook* tria_hmatice, Hook* tria_hmatpar, Hook* tria_hnumpar, ElementProperties* tria_properties);
		Tria(int i, IoModel* iomodel);
		~Tria();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		void  Configure(void* loads,void* nodes,void* materials,void* parameters);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   GetId(); 
		char* GetName();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  UpdateFromDakota(void* inputs);
		void  UpdateFromInputs(void* inputs);
	/*}}}*/
		/*FUNCTION element numerical routines {{{1*/
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
				void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void  CreateKMatrixDiagnosticHoriz(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticHorizFriction(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticSurfaceVert(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixSlopeCompute(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  GetParameterValue(double* pp, double* plist, double* gauss_l1l2l3);
		void  GetParameterDerivativeValue(double* p, double* plist,double* xyz_list, double* gauss_l1l2l3);
		void  GetStrainRate(double* epsilon, double* velocity, double* xyz_list, double* gauss_l1l2l3);
		void  GetJacobianDeterminant2d(double*  Jdet, double* xyz_list,double* gauss_l1l2l3);
		void  GetJacobianDeterminant3d(double*  Jdet, double* xyz_list,double* gauss_l1l2l3);
		void  GetB(double* B, double* xyz_list, double* gauss_l1l2l3);
		void  GetBPrime(double* Bprime, double* xyz_list, double* gauss_l1l2l3);
		void  GetL(double* L, double* xyz_list, double* gauss_l1l2l3,int numdof);
		void  GetB_prog(double* B_prog, double* xyz_list, double* gauss_l1l2l3);
		void  GetBPrime_prog(double* Bprime_prog, double* xyz_list, double* gauss_l1l2l3);
		void  GetNodalFunctions(double* l1l2l3, double* gauss_l1l2l3);
		void  GetNodalFunctionsDerivatives(double* dh1dh3,double* xyz_list, double* gauss_l1l2l3);
		void  GetNodalFunctionsDerivativesReference(double* dl1dl3,double* gauss_l1l2l3);
		void  GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss_l1l2l3);
		void  GetJacobian(double* J, double* xyz_list,double* gauss_l1l2l3);
		void  Du(Vec du_g,void* inputs,int analysis_type,int sub_analysis_type);
		void  Gradj(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type,char* control_type);
		void  GradjDrag(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type);
		void  GradjDragStokes(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type);
		void  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		void  GradjB(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type);
		double Misfit(void* inputs,int analysis_type,int sub_analysis_type);
		double SurfaceArea(void* inputs,int analysis_type,int sub_analysis_type);
		double CostFunction(void* inputs,int analysis_type,int sub_analysis_type);

		void  CreatePVectorDiagnosticHoriz(Vec pg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticBaseVert(Vec pg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorSlopeCompute( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);
		void* GetMatPar();
		int   GetShelf();
		void  GetNodes(void** nodes);
		int   GetOnBed();

		void  GetThicknessList(double* thickness_list);
		void  GetBedList(double* bed_list);
		void  ComputePressure(Vec p_g);
		void  CreateKMatrixThermal(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixMelting(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorThermalShelf( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);
		void  CreatePVectorThermalSheet( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);
		void  CreateKMatrixPrognostic(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorPrognostic(Vec pg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixPrognostic2(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorPrognostic2(Vec pg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBalancedthickness(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorBalancedthickness(Vec pg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBalancedvelocities(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorBalancedvelocities(Vec pg,void* vinputs,int analysis_type,int sub_analysis_type);
		double MassFlux(double* segment,double* ug);
		double GetArea(void);
		double GetAreaCoordinate(double x, double y, int which_one);
		/*}}}*/

};
#endif  /* _TRIA_H */
