/*!\file: DofIndexing.h
 * \brief prototype for DofIndexing.h
 */ 

#ifndef _DOFINDEXING_H_
#define  _DOFINDEXING_H_

#define MAXDOFSPERNODE 4

class DofIndexing{
	
	public:

		int numberofdofs; //number of dofs for a node.

		/*partitioning: */
		int     partitionborder; /*! during parallel partitioning, does this grid belong to a partition border?*/
		int     clone;  /*!this nodes is one the partition border, and is cloned*/

		/*boundary conditions sets: */
		int     m_set[MAXDOFSPERNODE];
		int     n_set[MAXDOFSPERNODE];
		int     f_set[MAXDOFSPERNODE];
		int     s_set[MAXDOFSPERNODE];

		/*list of degrees of freedom: */
		int     doflist[MAXDOFSPERNODE]; //dof list on which we solve

		DofIndexing();
		DofIndexing(int numberofdofs, int partitionborder);
		void Init(int numberofdofs, int partitionborder);
		DofIndexing(DofIndexing* properties);
		~DofIndexing();
		
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		void  copy(DofIndexing* properties);
		void  Echo(void); 
		void  DeepEcho(void); 
		DofIndexing* Spawn(int* indices, int numindices);

};
#endif //ifndef _DOFINDEXING_H_

		
