/*!\file: NodeProperties.h
 * \brief prototype for NodeProperties.h
 */ 

#ifndef _NODEPROPERTIES_H_
#define  _NODEPROPERTIES_H_

class NodeProperties{
	
	public:
		
		int	    onbed; /*! for 3d, on bedrock*/
		int	    onsurface; /*! for 3d, on surface*/
		int	    onshelf; 
		int	    onsheet;

		NodeProperties();
		NodeProperties(int onbed, int onsurface, int onshelf, int onsheet);
		Init(int onbed, int onsurface, int onshelf, int onsheet);
		NodeProperties(NodeProperties* properties);
		~NodeProperties();
		
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		void  copy(NodeProperties* properties);
		void  Echo(void); 
		void  DeepEcho(void); 

};
#endif //ifndef _NODEPROPERTIES_H_

		
