/*!\file Matice.h
 * \brief: header file for matice object
 */

#ifndef MATICE_H_
#define MATICE_H_

#include "./Material.h"

class Matice: public Material{

	private: 
		int	   mid;
		double B;
		double n;

	public:

		Matice();
		Matice(int mid,double B,double n);
		Matice(int i, IoModel* iomodel, int num_vertices);
		Init(int mid,double B,double n);
		~Matice();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  DistributeNumDofs(int* numdofspernode,int analysis_type);
		void  UpdateFromInputs(void* inputs);
		void  SetB(double B_param);
		void  GetViscosity2d(double* pviscosity, double* pepsilon);
		void  GetViscosity3d(double* pviscosity3d, double* pepsilon);
		void  GetViscosity3dStokes(double* pviscosity3d, double* epsilon);
		void  GetViscosityComplement(double* pviscosity_complement, double* pepsilon);
		Object* copy();
		double GetB();
		double GetN();

};

#endif  /* _MATICE_H_ */
