/*!\file DofIndexing.c
 * \brief: implementation of the DofIndexing object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./DofIndexing.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../DataSet/DataSet.h"
#include "../include/typedefs.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION DofIndexing default constructor {{{1*/
DofIndexing::DofIndexing(){

	int i;
	this->numberofdofs=UNDEF;
	this->partitionborder=UNDEF;
	this->clone=UNDEF;

	for (i=0;i<MAXDOFSPERNODE;i++){
		/*assume dof is free, no constraints, no rigid body constraint: */
		this->m_set[i]=0;
		this->n_set[i]=1;
		this->f_set[i]=1;
		this->s_set[i]=0;
		this->doflist[i]=UNDEF;
	}
}
/*}}}*/
/*FUNCTION DofIndexing constructor {{{1*/
DofIndexing::DofIndexing(int in_numberofdofs, int in_partitionborder){

	int i;
	this->numberofdofs=in_numberofdofs;
	this->partitionborder=in_partitionborder;
	this->clone=UNDEF;

	for (i=0;i<MAXDOFSPERNODE;i++){
		/*assume dof is free, no constraints, no rigid body constraint: */
		this->m_set[i]=0;
		this->n_set[i]=1;
		this->f_set[i]=1;
		this->s_set[i]=0;
		this->doflist[i]=UNDEF;
	}
}
/*}}}*/
/*FUNCTION DofIndexing copy constructor{{{1*/
DofIndexing::DofIndexing(DofIndexing* in){ //copy constructor

	int i;
	this->numberofdofs=in->numberofdofs;
	this->partitionborder=in->partitionborder;
	this->clone=in->clone;

	for(i=0;i<MAXDOFSPERNODE;i++){
		this->m_set[i]=in->m_set[i];
		this->n_set[i]=in->n_set[i];
		this->f_set[i]=in->f_set[i];
		this->s_set[i]=in->s_set[i];
		this->doflist[i]=in->doflist[i];
	}
}
/*}}}*/
/*FUNCTION DofIndexing destructor {{{1*/
DofIndexing::~DofIndexing(){ //destructor
}
/*}}}*/

/*Object management: */
/*FUNCTION DofIndexing Marshall{{{1*/
void  DofIndexing::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of DofIndexing: */
	enum_type=DofIndexingEnum();
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall DofIndexing data: */
	memcpy(marshalled_dataset,&numberofdofs,sizeof(numberofdofs));marshalled_dataset+=sizeof(numberofdofs);
	memcpy(marshalled_dataset,&partitionborder,sizeof(partitionborder));marshalled_dataset+=sizeof(partitionborder);
	memcpy(marshalled_dataset,&clone,sizeof(clone));marshalled_dataset+=sizeof(clone);
	memcpy(marshalled_dataset,&m_set,sizeof(m_set));marshalled_dataset+=sizeof(m_set);
	memcpy(marshalled_dataset,&n_set,sizeof(n_set));marshalled_dataset+=sizeof(n_set);
	memcpy(marshalled_dataset,&f_set,sizeof(f_set));marshalled_dataset+=sizeof(f_set);
	memcpy(marshalled_dataset,&s_set,sizeof(s_set));marshalled_dataset+=sizeof(s_set);
	memcpy(marshalled_dataset,&doflist,sizeof(doflist));marshalled_dataset+=sizeof(doflist);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DofIndexing MarshallSize{{{1*/
int   DofIndexing::MarshallSize(){

	return sizeof(numberofdofs)+
		sizeof(partitionborder)+
		sizeof(clone)+
		sizeof(m_set)+
		sizeof(n_set)+
		sizeof(f_set)+
		sizeof(s_set)+
		sizeof(doflist)+
		sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION DofIndexing Demarshall{{{1*/
void  DofIndexing::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&numberofdofs,marshalled_dataset,sizeof(numberofdofs));marshalled_dataset+=sizeof(numberofdofs);
	memcpy(&partitionborder,marshalled_dataset,sizeof(partitionborder));marshalled_dataset+=sizeof(partitionborder);
	memcpy(&clone,marshalled_dataset,sizeof(clone));marshalled_dataset+=sizeof(clone);
	memcpy(&m_set,marshalled_dataset,sizeof(m_set));marshalled_dataset+=sizeof(m_set);
	memcpy(&n_set,marshalled_dataset,sizeof(n_set));marshalled_dataset+=sizeof(n_set);
	memcpy(&f_set,marshalled_dataset,sizeof(f_set));marshalled_dataset+=sizeof(f_set);
	memcpy(&s_set,marshalled_dataset,sizeof(s_set));marshalled_dataset+=sizeof(s_set);
	memcpy(&doflist,marshalled_dataset,sizeof(doflist));marshalled_dataset+=sizeof(doflist);
	
	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DofIndexing Echo{{{1*/
void DofIndexing::Echo(void){

	int i;

	printf("DofIndexing:\n");
	printf("   numberofdofs: %i\n",numberofdofs);
	printf("   partitionborder: %i\n",partitionborder);
	printf("   clone: %i\n",clone);
}
/*}}}*/
/*FUNCTION DofIndexing DeepEcho{{{1*/
void DofIndexing::DeepEcho(void){

	int i;

	printf("DofIndexing:\n");
	printf("   numberofdofs: %i\n",numberofdofs);
	printf("   partitionborder: %i\n",partitionborder);
	printf("   clone: %i\n",clone);
	
	printf("   set membership: m,n,f,s sets \n");
	for(i=0;i<numberofdofs;i++){
		if(i>MAXDOFSPERNODE)break;
		printf("      dof %i: %i %i %i %i\n",i,m_set[i],n_set[i],f_set[i],s_set[i]);
	}
	printf("\n");

	printf("   doflist:|");
	for(i=0;i<numberofdofs;i++){
		if(i>MAXDOFSPERNODE)break;
		printf("%i|",doflist[i]);
	}

}		
/*}}}*/
