/*!\file Matpar.h
 * \brief: header file for matpar object
 */

#ifndef _MATPAR_H_
#define _MATPAR_H_

#include "./Material.h"

class Matpar: public Material{

	private: 
		int	mid;
		double	rho_ice; 
		double	rho_water;
		double  heatcapacity;
		double  thermalconductivity;
		double  latentheat;
		double  beta;
		double  meltingpoint;
		double  mixed_layer_capacity;
		double  thermal_exchange_velocity;
		double  g;

	public:

		Matpar();
	
		Matpar(int	mid, double	rho_ice, double	rho_water, double  heatcapacity, double  thermalconductivity, double  latentheat, double  beta, double  meltingpoint, double  mixed_layer_capacity, double  thermal_exchange_velocity, double  g);
		Init(int	mid, double	rho_ice, double	rho_water, double  heatcapacity, double  thermalconductivity, double  latentheat, double  beta, double  meltingpoint, double  mixed_layer_capacity, double  thermal_exchange_velocity, double  g);
		Matpar(IoModel* iomodel);
		
		~Matpar();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  DistributeNumDofs(int* numdofspernode,int analysis_type);
		void  UpdateFromInputs(void* inputs);
		double GetG();
		double GetRhoIce();
		double GetRhoWater();
		double GetMixedLayerCapacity();
		double GetThermalExchangeVelocity();
		double GetHeatCapacity();
		double GetThermalConductivity();
		double GetLatentHeat();
		double GetBeta();
		double GetMeltingPoint();
		Object* copy();

};

#endif  /* _MATPAR_H_ */
