%this test computes the time needed for a diagnostic in 2d
%depending on the connectivity

%connectivity and density
Connectivity=13:23;
%Density=5000:1000:9000;  %parallel 2d
Density=20000:1000:24000;  %parallel 3d

%loop over every case
count=1;
time=zeros(length(Density),length(Connectivity));
numelements=zeros(length(Density));
numcases=length(Density)*length(Connectivity);
subplotwidth=ceil(sqrt(length(Density)));
for i=1:length(Density),
	for j=1:length(Connectivity),
		density=Density(i);
		connectivity=Connectivity(j);

		disp(sprintf('\nSTEP %i/%i : (density=%i, connectivity=%i)\n',count,numcases,density,connectivity));

		%create model
		md=model;
		md=mesh(md,'DomainOutline.exp',density);
		md=geography(md,'all','');
		md=parameterize(md,'Square.par');
		md.connectivity=connectivity;
		md=extrude(md,4,5);
		md=setelementstype(md,'pattyn','all');

		%diagnostic
		t1=clock;
		%md=solve(md,'diagnostic','cielo');
		md.cluster='wilkes'; md=solve(md,'diagnostic_horiz','cielo');
		t2=clock;

		%save time
		time(i,j)=etime(t2,t1);
		count=count+1;

	end
	numelements(i)=md.numberofelements;
end

%display result
disp(sprintf('\nResults\n'));
disp(sprintf('   STEP  density  connectivity   time',count));
for i=1:length(Density),
	for j=1:length(Connectivity),
		disp(sprintf(['%4i/%i %i %11i        ' num2str(time(i,j))],count,numcases,Density(i),Connectivity(j)));
		count=count+1;
	end
	[dummy pos]=min(time(i,:));

	%plot results
	subplot(subplotwidth,subplotwidth,i)
	plot(Connectivity,time(i,:));
	hold on
	plot([Connectivity(1);Connectivity(end)],time(i,pos)*ones(2,1),'-r');

	title(['computation time for '  num2str(numelements(i)) ' elements'],'FontSize',14);
	xlabel('Connectivity','FontSize',14)
	ylabel('time (s)','FontSize',14)
end

